/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public abstract class Widget {
    protected final Composite parent;
    protected final FormToolkit toolkit;
    protected final RuleModeller modeller;
    protected final int index;

    public Widget(Composite composite, FormToolkit formToolkit, RuleModeller ruleModeller, int n) {
        this.parent = composite;
        this.toolkit = formToolkit;
        this.modeller = ruleModeller;
        this.index = n;
    }

    public ImageHyperlink addImage(Composite composite, String string) {
        ImageHyperlink imageHyperlink = this.toolkit.createImageHyperlink(composite, 0);
        ImageDescriptor imageDescriptor = DroolsEclipsePlugin.getImageDescriptor(string);
        imageHyperlink.setImage(imageDescriptor.createImage());
        return imageHyperlink;
    }

    protected void addDeleteRHSAction() {
        ImageHyperlink imageHyperlink = this.addImage(this.parent, "icons/delete_obj.gif");
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                messageBox.setMessage("Remove this action?");
                messageBox.setText("Remove this action?");
                if (messageBox.open() == 64) {
                    Widget.this.getModeller().getModel().removeRhsItem(Widget.this.index);
                    Widget.this.getModeller().setDirty(true);
                    Widget.this.getModeller().reloadRhs();
                }
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }
        });
        imageHyperlink.setToolTipText("Remove this action.");
    }

    protected void showMessage(String string) {
        MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 34);
        messageBox.setMessage(string);
        messageBox.setText("Information");
        messageBox.open();
    }

    protected RuleModeller getModeller() {
        return this.modeller;
    }
}

