/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.util.DefaultDroolsRuntimeRecognizer;
import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.util.DroolsRuntimeRecognizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class DroolsRuntimeManager {
    private static final String DROOLS_RUNTIME_RECOGNIZER = "org.drools.eclipse.runtimeRecognizer";

    public static void createDefaultRuntime(String string) {
        int n;
        File[] fileArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = DroolsRuntimeManager.getDroolsLocation();
        File file = new Path(string2).toFile();
        File[] fileArray2 = file.listFiles();
        int n2 = 0;
        while (n2 < fileArray2.length) {
            if (fileArray2[n2].isDirectory() && fileArray2[n2].getName().equals("lib")) {
                fileArray = fileArray2[n2].listFiles();
                n = 0;
                while (n < fileArray.length) {
                    if (fileArray[n].getPath().endsWith(".jar")) {
                        arrayList.add(fileArray[n].getAbsolutePath());
                    }
                    ++n;
                }
            }
            ++n2;
        }
        String string3 = String.valueOf(Platform.getInstallLocation().getURL().getPath()) + "plugins/";
        fileArray = new Path(string3).toFile();
        fileArray2 = fileArray.listFiles();
        n = 0;
        int n3 = 0;
        while (n3 < fileArray2.length) {
            if (fileArray2[n3].getAbsolutePath().indexOf("org.eclipse.jdt.core_3.6") > -1) {
                arrayList.add(fileArray2[n3].getAbsolutePath());
                n = 1;
                break;
            }
            ++n3;
        }
        if (n == 0) {
            n3 = 0;
            while (n3 < fileArray2.length) {
                if (fileArray2[n3].getAbsolutePath().indexOf("org.eclipse.jdt.core_3.5") > -1) {
                    arrayList.add(fileArray2[n3].getAbsolutePath());
                    n = 1;
                    break;
                }
                ++n3;
            }
        }
        if (n == 0) {
            n3 = 0;
            while (n3 < fileArray2.length) {
                if (fileArray2[n3].getAbsolutePath().indexOf("org.eclipse.jdt.core_3.4") > -1) {
                    arrayList.add(fileArray2[n3].getAbsolutePath());
                    break;
                }
                ++n3;
            }
        }
        if (!string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        for (String string4 : arrayList) {
            try {
                File file2 = new File(string4);
                FileChannel fileChannel = new FileInputStream(file2).getChannel();
                FileChannel fileChannel2 = new FileOutputStream(new File(String.valueOf(string) + file2.getName())).getChannel();
                try {
                    fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
                }
                finally {
                    if (fileChannel != null) {
                        fileChannel.close();
                    }
                    if (fileChannel2 != null) {
                        fileChannel2.close();
                    }
                }
            }
            catch (Throwable throwable) {
                DroolsEclipsePlugin.log(throwable);
            }
        }
    }

    private static String getDroolsLocation() {
        try {
            return FileLocator.toFileURL((URL)Platform.getBundle((String)"org.drools.eclipse").getEntry("/")).getFile().toString();
        }
        catch (IOException iOException) {
            DroolsEclipsePlugin.log(iOException);
            return null;
        }
    }

    private static String generateString(DroolsRuntime[] droolsRuntimeArray) {
        String string = "";
        DroolsRuntime[] droolsRuntimeArray2 = droolsRuntimeArray;
        int n = droolsRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DroolsRuntime droolsRuntime = droolsRuntimeArray2[n2];
            string = String.valueOf(string) + droolsRuntime.getName() + "#" + droolsRuntime.getPath() + "#" + droolsRuntime.isDefault() + "# ";
            if (droolsRuntime.getJars() != null) {
                String[] stringArray = droolsRuntime.getJars();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string2 = stringArray[n4];
                    string = String.valueOf(string) + string2 + ";";
                    ++n4;
                }
            }
            string = String.valueOf(string) + "###";
            ++n2;
        }
        return string;
    }

    private static DroolsRuntime[] generateRuntimes(String string) {
        ArrayList<DroolsRuntime> arrayList = new ArrayList<DroolsRuntime>();
        if (string != null && !"".equals(string)) {
            String[] stringArray;
            String[] stringArray2 = stringArray = string.split("###");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                String[] stringArray3 = string2.split("#");
                DroolsRuntime droolsRuntime = new DroolsRuntime();
                droolsRuntime.setName(stringArray3[0]);
                droolsRuntime.setPath(stringArray3[1]);
                droolsRuntime.setDefault("true".equals(stringArray3[2]));
                if (stringArray3.length > 3) {
                    String[] stringArray4;
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    String[] stringArray5 = stringArray4 = stringArray3[3].split(";");
                    int n3 = stringArray4.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String string3 = stringArray5[n4];
                        if ((string3 = string3.trim()).length() > 0) {
                            arrayList2.add(string3);
                        }
                        ++n4;
                    }
                    droolsRuntime.setJars(arrayList2.toArray(new String[arrayList2.size()]));
                }
                arrayList.add(droolsRuntime);
                ++n2;
            }
        }
        return arrayList.toArray(new DroolsRuntime[arrayList.size()]);
    }

    public static DroolsRuntime[] getDroolsRuntimes() {
        String string = DroolsEclipsePlugin.getDefault().getPreferenceStore().getString("Drools.Runtimes");
        if (string != null) {
            return DroolsRuntimeManager.generateRuntimes(string);
        }
        return new DroolsRuntime[0];
    }

    public static void setDroolsRuntimes(DroolsRuntime[] droolsRuntimeArray) {
        DroolsEclipsePlugin.getDefault().getPreferenceStore().setValue("Drools.Runtimes", DroolsRuntimeManager.generateString(droolsRuntimeArray));
    }

    public static DroolsRuntime getDroolsRuntime(String string) {
        DroolsRuntime[] droolsRuntimeArray;
        DroolsRuntime[] droolsRuntimeArray2 = droolsRuntimeArray = DroolsRuntimeManager.getDroolsRuntimes();
        int n = droolsRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DroolsRuntime droolsRuntime = droolsRuntimeArray2[n2];
            if (droolsRuntime.getName().equals(string)) {
                return droolsRuntime;
            }
            ++n2;
        }
        return null;
    }

    public static DroolsRuntime getDefaultDroolsRuntime() {
        DroolsRuntime[] droolsRuntimeArray;
        DroolsRuntime[] droolsRuntimeArray2 = droolsRuntimeArray = DroolsRuntimeManager.getDroolsRuntimes();
        int n = droolsRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DroolsRuntime droolsRuntime = droolsRuntimeArray2[n2];
            if (droolsRuntime.isDefault()) {
                return droolsRuntime;
            }
            ++n2;
        }
        return null;
    }

    public static String getDroolsRuntime(IProject iProject) {
        try {
            BufferedReader bufferedReader;
            String string;
            IFile iFile = iProject.getFile(".settings/.drools.runtime");
            if (iFile.exists() && (string = (bufferedReader = new BufferedReader(new InputStreamReader(iFile.getContents()))).readLine()).startsWith("<runtime>") && string.endsWith("</runtime>")) {
                return string.substring(9, string.length() - 10);
            }
        }
        catch (Exception exception) {
            DroolsEclipsePlugin.log(exception);
        }
        return null;
    }

    public static String[] getDroolsRuntimeJars(IProject iProject) {
        String string = DroolsRuntimeManager.getDroolsRuntime(iProject);
        DroolsRuntime droolsRuntime = null;
        droolsRuntime = string == null ? DroolsRuntimeManager.getDefaultDroolsRuntime() : DroolsRuntimeManager.getDroolsRuntime(string);
        if (droolsRuntime == null) {
            return null;
        }
        if (droolsRuntime.getJars() == null || droolsRuntime.getJars().length == 0) {
            DroolsRuntimeManager.recognizeJars(droolsRuntime);
        }
        return droolsRuntime.getJars();
    }

    public static void recognizeJars(DroolsRuntime droolsRuntime) {
        String string = droolsRuntime.getPath();
        if (string != null) {
            try {
                IConfigurationElement[] iConfigurationElementArray;
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(DROOLS_RUNTIME_RECOGNIZER);
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] stringArray;
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                    Object object = iConfigurationElement.createExecutableExtension("class");
                    if (object instanceof DroolsRuntimeRecognizer && (stringArray = ((DroolsRuntimeRecognizer)object).recognizeJars(string)) != null && stringArray.length > 0) {
                        droolsRuntime.setJars(stringArray);
                        return;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
            droolsRuntime.setJars(new DefaultDroolsRuntimeRecognizer().recognizeJars(string));
        }
    }
}

