/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectClassLoader {
    public static URLClassLoader getProjectClassLoader(IEditorPart iEditorPart) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            return ProjectClassLoader.getProjectClassLoader(((IFileEditorInput)iEditorInput).getFile());
        }
        return null;
    }

    public static URLClassLoader getProjectClassLoader(IFile iFile) {
        IProject iProject = iFile.getProject();
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        return ProjectClassLoader.getProjectClassLoader(iJavaProject);
    }

    public static URLClassLoader getProjectClassLoader(IJavaProject iJavaProject) {
        List<URL> list = ProjectClassLoader.getProjectClassPathURLs(iJavaProject, new ArrayList<String>());
        URL[] uRLArray = list.toArray(new URL[list.size()]);
        return new URLClassLoader(uRLArray, Thread.currentThread().getContextClassLoader());
    }

    private static URL getRawLocationURL(IPath iPath) throws MalformedURLException {
        File file = ProjectClassLoader.getRawLocationFile(iPath);
        return file.toURI().toURL();
    }

    private static File getRawLocationFile(IPath iPath) {
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
        File file = null;
        file = iResource != null ? ResourcesPlugin.getWorkspace().getRoot().findMember(iPath).getRawLocation().toFile() : iPath.toFile();
        return file;
    }

    public static List<URL> getProjectClassPathURLs(IJavaProject iJavaProject, List<String> list) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        try {
            IClasspathEntry iClasspathEntry;
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getResolvedClasspath(true);
            HashSet<IPath> hashSet = new HashSet<IPath>();
            if (iClasspathEntryArray != null) {
                int n = 0;
                while (n < iClasspathEntryArray.length) {
                    iClasspathEntry = iClasspathEntryArray[n];
                    if (iClasspathEntry.getEntryKind() == 1) {
                        URL uRL = ProjectClassLoader.getRawLocationURL(iClasspathEntry.getPath());
                        arrayList.add(uRL);
                    } else if (iClasspathEntry.getEntryKind() == 3) {
                        IPath iPath = iClasspathEntry.getOutputLocation();
                        if (iClasspathEntry.getOutputLocation() != null) {
                            hashSet.add(iPath);
                        }
                    }
                    ++n;
                }
            }
            IPath iPath = ProjectClassLoader.getProjectLocation(iJavaProject.getProject());
            iClasspathEntry = iPath.append(iJavaProject.getOutputLocation().removeFirstSegments(1));
            arrayList.add(0, iClasspathEntry.toFile().toURI().toURL());
            for (IPath iPath2 : hashSet) {
                iClasspathEntry = iPath.append(iPath2.removeFirstSegments(1));
                arrayList.add(0, iClasspathEntry.toFile().toURI().toURL());
            }
            String[] stringArray = iJavaProject.getRequiredProjectNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (!list.contains(string)) {
                    list.add(string);
                    IProject iProject = iJavaProject.getProject().getWorkspace().getRoot().getProject(string);
                    if (iProject != null) {
                        IJavaProject iJavaProject2 = JavaCore.create((IProject)iProject);
                        arrayList.addAll(ProjectClassLoader.getProjectClassPathURLs(iJavaProject2, list));
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            DroolsEclipsePlugin.log(javaModelException);
        }
        catch (MalformedURLException malformedURLException) {
            DroolsEclipsePlugin.log(malformedURLException);
        }
        catch (Throwable throwable) {
            DroolsEclipsePlugin.log(throwable);
        }
        return arrayList;
    }

    public static IPath getProjectLocation(IProject iProject) {
        if (iProject.getRawLocation() == null) {
            return iProject.getLocation();
        }
        return iProject.getRawLocation();
    }
}

