/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.wizard.project;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.util.DroolsClasspathContainer;
import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.wizard.project.NewDroolsProjectRuntimeWizardPage;
import org.drools.eclipse.wizard.project.NewDroolsProjectWizardPage;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewDroolsProjectWizard
extends BasicNewResourceWizard {
    public static final String DROOLS_CLASSPATH_CONTAINER_PATH = "DROOLS/Drools";
    private IProject newProject;
    private WizardNewProjectCreationPage mainPage;
    private NewDroolsProjectWizardPage extraPage;
    private NewDroolsProjectRuntimeWizardPage runtimePage;

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage("basicNewProjectPage");
        this.mainPage.setTitle("\u65b0\u3057\u3044Drools\u30d7\u30ed\u30b8\u30a7\u30af\u30c8");
        this.mainPage.setDescription("\u65b0\u3057\u3044Drools\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u3092\u4f5c\u6210\u3059\u308b\u3002");
        this.addPage((IWizardPage)this.mainPage);
        this.extraPage = new NewDroolsProjectWizardPage();
        this.addPage((IWizardPage)this.extraPage);
        this.runtimePage = new NewDroolsProjectRuntimeWizardPage();
        this.addPage((IWizardPage)this.runtimePage);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.createDroolsProject();
        if (this.newProject == null) {
            return false;
        }
        this.selectAndReveal((IResource)this.newProject);
        return true;
    }

    private void createDroolsProject() {
        this.newProject = this.createNewProject();
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    IJavaProject iJavaProject = JavaCore.create((IProject)NewDroolsProjectWizard.this.newProject);
                    NewDroolsProjectWizard.this.createDroolsRuntime(iJavaProject, iProgressMonitor);
                    NewDroolsProjectWizard.this.createOutputLocation(iJavaProject, iProgressMonitor);
                    NewDroolsProjectWizard.this.addJavaBuilder(iJavaProject, iProgressMonitor);
                    NewDroolsProjectWizard.this.setClasspath(iJavaProject, iProgressMonitor);
                    NewDroolsProjectWizard.this.createInitialContent(iJavaProject, iProgressMonitor);
                    NewDroolsProjectWizard.this.newProject.build(6, iProgressMonitor);
                }
                catch (IOException iOException) {
                    ErrorDialog.openError((Shell)NewDroolsProjectWizard.this.getShell(), (String)"Drools\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002", null, null);
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (Throwable throwable) {
            DroolsEclipsePlugin.log(throwable);
        }
    }

    private IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        final IProject iProject = this.mainPage.getProjectHandle();
        IPath iPath = null;
        if (!this.mainPage.useDefaults()) {
            iPath = this.mainPage.getLocationPath();
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
        iProjectDescription.setLocation(iPath);
        this.addNatures(iProjectDescription);
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                NewDroolsProjectWizard.this.createProject(iProjectDescription, iProject, iProgressMonitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof CoreException) {
                if (((CoreException)throwable).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"NewProject.errorMessage", (String)("NewProject.caseVariantExistsError" + iProject.getName()));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"NewProject.errorMessage", null, (IStatus)((CoreException)throwable).getStatus());
                }
            } else {
                DroolsEclipsePlugin.log(invocationTargetException);
            }
            return null;
        }
        return iProject;
    }

    private void addNatures(IProjectDescription iProjectDescription) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(iProjectDescription.getNatureIds()));
        arrayList.add("org.eclipse.jdt.core.javanature");
        iProjectDescription.setNatureIds(arrayList.toArray(new String[arrayList.size()]));
    }

    private void createProject(IProjectDescription iProjectDescription, IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        try {
            iProgressMonitor.beginTask("", 2000);
            iProject.create(iProjectDescription, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            iProject.open(128, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void createDroolsRuntime(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        DroolsRuntime droolsRuntime = this.runtimePage.getDroolsRuntime();
        if (droolsRuntime != null) {
            IFile iFile = iJavaProject.getProject().getFile(".settings/.drools.runtime");
            String string = "<runtime>" + droolsRuntime.getName() + "</runtime>";
            if (!iFile.exists()) {
                IFolder iFolder = iJavaProject.getProject().getFolder(".settings");
                if (!iFolder.exists()) {
                    iFolder.create(true, true, null);
                }
                iFile.create((InputStream)new ByteArrayInputStream(string.getBytes()), true, null);
            } else {
                iFile.setContents((InputStream)new ByteArrayInputStream(string.getBytes()), true, false, null);
            }
        }
    }

    private void createOutputLocation(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException, CoreException {
        IFolder iFolder = iJavaProject.getProject().getFolder("bin");
        this.createFolder(iFolder, iProgressMonitor);
        IPath iPath = iFolder.getFullPath();
        iJavaProject.setOutputLocation(iPath, null);
    }

    private void addJavaBuilder(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        IProjectDescription iProjectDescription = iJavaProject.getProject().getDescription();
        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
        ICommand[] iCommandArray2 = new ICommand[iCommandArray.length + 2];
        System.arraycopy(iCommandArray, 0, iCommandArray2, 0, iCommandArray.length);
        ICommand iCommand = iProjectDescription.newCommand();
        iCommand.setBuilderName("org.eclipse.jdt.core.javabuilder");
        iCommandArray2[iCommandArray.length] = iCommand;
        ICommand iCommand2 = iProjectDescription.newCommand();
        iCommand2.setBuilderName("org.drools.eclipse.droolsbuilder");
        iCommandArray2[iCommandArray.length + 1] = iCommand2;
        iProjectDescription.setBuildSpec(iCommandArray2);
        iJavaProject.getProject().setDescription(iProjectDescription, iProgressMonitor);
    }

    private void setClasspath(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException, CoreException {
        iJavaProject.setRawClasspath(new IClasspathEntry[0], iProgressMonitor);
        this.addSourceFolders(iJavaProject, iProgressMonitor);
        this.addJRELibraries(iJavaProject, iProgressMonitor);
        NewDroolsProjectWizard.addDroolsLibraries(iJavaProject, iProgressMonitor);
    }

    private void addSourceFolders(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException, CoreException {
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
        arrayList.addAll(Arrays.asList(iJavaProject.getRawClasspath()));
        this.addSourceFolder(iJavaProject, arrayList, "src/main/java", iProgressMonitor);
        this.addSourceFolder(iJavaProject, arrayList, "src/main/rules", iProgressMonitor);
        iJavaProject.setRawClasspath(arrayList.toArray(new IClasspathEntry[arrayList.size()]), null);
    }

    private void addJRELibraries(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
        arrayList.addAll(Arrays.asList(iJavaProject.getRawClasspath()));
        arrayList.addAll(Arrays.asList(PreferenceConstants.getDefaultJRELibrary()));
        iJavaProject.setRawClasspath(arrayList.toArray(new IClasspathEntry[arrayList.size()]), iProgressMonitor);
    }

    private static IPath getClassPathContainerPath() {
        return new Path(DROOLS_CLASSPATH_CONTAINER_PATH);
    }

    private static void createDroolsLibraryContainer(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        JavaCore.setClasspathContainer((IPath)NewDroolsProjectWizard.getClassPathContainerPath(), (IJavaProject[])new IJavaProject[]{iJavaProject}, (IClasspathContainer[])new IClasspathContainer[]{new DroolsClasspathContainer(iJavaProject, NewDroolsProjectWizard.getClassPathContainerPath())}, (IProgressMonitor)iProgressMonitor);
    }

    public static void addDroolsLibraries(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        NewDroolsProjectWizard.createDroolsLibraryContainer(iJavaProject, iProgressMonitor);
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
        arrayList.addAll(Arrays.asList(iJavaProject.getRawClasspath()));
        arrayList.add(JavaCore.newContainerEntry((IPath)NewDroolsProjectWizard.getClassPathContainerPath()));
        iJavaProject.setRawClasspath(arrayList.toArray(new IClasspathEntry[arrayList.size()]), iProgressMonitor);
    }

    private void createInitialContent(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException, JavaModelException, IOException {
        try {
            if (this.extraPage.createJavaRuleFile()) {
                this.createRuleSampleLauncher(iJavaProject);
            }
            if (this.extraPage.createRuleFile()) {
                this.createRule(iJavaProject, iProgressMonitor);
            }
            if (this.extraPage.createDecisionTableFile()) {
                this.createDecisionTable(iJavaProject, iProgressMonitor);
            }
            if (this.extraPage.createJavaDecisionTableFile()) {
                this.createDecisionTableSampleLauncher(iJavaProject);
            }
            if (this.extraPage.createRuleFlowFile()) {
                this.createRuleFlow(iJavaProject, iProgressMonitor);
            }
            if (this.extraPage.createJavaRuleFlowFile()) {
                this.createRuleFlowSampleLauncher(iJavaProject);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void createRuleSampleLauncher(IJavaProject iJavaProject) throws JavaModelException, IOException {
        String string = this.runtimePage.getGenerationType() == "Drools 4.x" ? "org/drools/eclipse/wizard/project/RuleLauncherSample_4.java.template" : "org/drools/eclipse/wizard/project/RuleLauncherSample.java.template";
        IFolder iFolder = iJavaProject.getProject().getFolder("src/main/java");
        IPackageFragmentRoot iPackageFragmentRoot = iJavaProject.getPackageFragmentRoot((IResource)iFolder);
        IPackageFragment iPackageFragment = iPackageFragmentRoot.createPackageFragment("com.sample", true, null);
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string);
        iPackageFragment.createCompilationUnit("DroolsTest.java", new String(this.readStream(inputStream)), true, null);
    }

    private void createDecisionTableSampleLauncher(IJavaProject iJavaProject) throws JavaModelException, IOException {
        String string = this.runtimePage.getGenerationType() == "Drools 4.x" ? "org/drools/eclipse/wizard/project/DecisionTableLauncherSample_4.java.template" : "org/drools/eclipse/wizard/project/DecisionTableLauncherSample.java.template";
        IFolder iFolder = iJavaProject.getProject().getFolder("src/main/java");
        IPackageFragmentRoot iPackageFragmentRoot = iJavaProject.getPackageFragmentRoot((IResource)iFolder);
        IPackageFragment iPackageFragment = iPackageFragmentRoot.createPackageFragment("com.sample", true, null);
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string);
        iPackageFragment.createCompilationUnit("DecisionTableTest.java", new String(this.readStream(inputStream)), true, null);
    }

    private void createRule(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        String string = "org/drools/eclipse/wizard/project/Sample.drl.template";
        IFolder iFolder = iJavaProject.getProject().getFolder("src/main/rules");
        IFile iFile = iFolder.getFile("Sample.drl");
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string);
        if (!iFile.exists()) {
            iFile.create(inputStream, true, iProgressMonitor);
        } else {
            iFile.setContents(inputStream, true, false, iProgressMonitor);
        }
    }

    private void createDecisionTable(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        String string = "org/drools/eclipse/wizard/project/Sample.xls.template";
        IFolder iFolder = iJavaProject.getProject().getFolder("src/main/rules");
        IFile iFile = iFolder.getFile("Sample.xls");
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string);
        if (!iFile.exists()) {
            iFile.create(inputStream, true, iProgressMonitor);
        } else {
            iFile.setContents(inputStream, true, false, iProgressMonitor);
        }
    }

    private void createRuleFlow(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        String string = this.runtimePage.getGenerationType();
        if ("Drools 4.x".equals(string)) {
            String string2 = "org/drools/eclipse/wizard/project/ruleflow_4.rf.template";
            IFolder iFolder = iJavaProject.getProject().getFolder("src/main/rules");
            IFile iFile = iFolder.getFile("ruleflow.rf");
            InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string2);
            if (!iFile.exists()) {
                iFile.create(inputStream, true, iProgressMonitor);
            } else {
                iFile.setContents(inputStream, true, false, iProgressMonitor);
            }
            string2 = "org/drools/eclipse/wizard/project/ruleflow_4.rfm.template";
            iFile = iFolder.getFile("ruleflow.rfm");
            inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string2);
            if (!iFile.exists()) {
                iFile.create(inputStream, true, iProgressMonitor);
            } else {
                iFile.setContents(inputStream, true, false, iProgressMonitor);
            }
            string2 = "org/drools/eclipse/wizard/project/ruleflow_4.drl.template";
            iFile = iFolder.getFile("ruleflow.drl");
            inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string2);
            if (!iFile.exists()) {
                iFile.create(inputStream, true, iProgressMonitor);
            } else {
                iFile.setContents(inputStream, true, false, iProgressMonitor);
            }
        } else if ("Drools 5.0.x".equals(string)) {
            String string3 = "org/drools/eclipse/wizard/project/ruleflow.rf.template";
            IFolder iFolder = iJavaProject.getProject().getFolder("src/main/rules");
            IFile iFile = iFolder.getFile("ruleflow.rf");
            InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string3);
            if (!iFile.exists()) {
                iFile.create(inputStream, true, iProgressMonitor);
            } else {
                iFile.setContents(inputStream, true, false, iProgressMonitor);
            }
        } else {
            String string4 = "org/drools/eclipse/wizard/project/sample.bpmn.template";
            IFolder iFolder = iJavaProject.getProject().getFolder("src/main/rules");
            IFile iFile = iFolder.getFile("sample.bpmn");
            InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string4);
            if (!iFile.exists()) {
                iFile.create(inputStream, true, iProgressMonitor);
            } else {
                iFile.setContents(inputStream, true, false, iProgressMonitor);
            }
        }
    }

    private void createRuleFlowSampleLauncher(IJavaProject iJavaProject) throws JavaModelException, IOException {
        String string = this.runtimePage.getGenerationType();
        String string2 = "Drools 4.x".equals(string) ? "org/drools/eclipse/wizard/project/RuleFlowLauncherSample_4.java.template" : ("Drools 5.0.x".equals(string) ? "org/drools/eclipse/wizard/project/RuleFlowLauncherSample.java.template" : "org/drools/eclipse/wizard/project/ProcessLauncherSample_bpmn.java.template");
        IFolder iFolder = iJavaProject.getProject().getFolder("src/main/java");
        IPackageFragmentRoot iPackageFragmentRoot = iJavaProject.getPackageFragmentRoot((IResource)iFolder);
        IPackageFragment iPackageFragment = iPackageFragmentRoot.createPackageFragment("com.sample", true, null);
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string2);
        iPackageFragment.createCompilationUnit("ProcessTest.java", new String(this.readStream(inputStream)), true, null);
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor imageDescriptor = DroolsEclipsePlugin.getImageDescriptor("icons/drools-large.PNG");
        this.setDefaultPageImageDescriptor(imageDescriptor);
    }

    private byte[] readStream(InputStream inputStream) throws IOException {
        byte[] byArray = null;
        int n = 0;
        byte[] byArray2 = new byte[1024];
        int n2 = inputStream.read(byArray2);
        while (n2 != -1) {
            byte[] byArray3 = new byte[n + n2];
            if (n > 0) {
                System.arraycopy(byArray, 0, byArray3, 0, n);
            }
            System.arraycopy(byArray2, 0, byArray3, n, n2);
            byArray = byArray3;
            n += n2;
            n2 = inputStream.read(byArray2);
        }
        return byArray;
    }

    private void addSourceFolder(IJavaProject iJavaProject, List list, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IFolder iFolder = iJavaProject.getProject().getFolder(string);
        this.createFolder(iFolder, iProgressMonitor);
        IPackageFragmentRoot iPackageFragmentRoot = iJavaProject.getPackageFragmentRoot((IResource)iFolder);
        list.add(JavaCore.newSourceEntry((IPath)iPackageFragmentRoot.getPath()));
    }

    private void createFolder(IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException {
        IContainer iContainer = iFolder.getParent();
        if (iContainer != null && !iContainer.exists() && iContainer instanceof IFolder) {
            this.createFolder((IFolder)iContainer, iProgressMonitor);
        }
        if (!iFolder.exists()) {
            iFolder.create(true, true, iProgressMonitor);
        }
    }
}

