/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.wizard.rule;

import java.io.IOException;
import java.io.InputStream;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.wizard.rule.DRLGenerator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NewRulePackagePage
extends WizardNewFileCreationPage {
    private static final int TYPE_RULE = 1;
    private static final int TYPE_PACKAGE = 0;
    private IWorkbench workbench;
    private Combo ruleFileType;
    private Button expander;
    private Button function;
    private Text packageName;

    public NewRulePackagePage(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super("createDRLFilePage", iStructuredSelection);
        this.setTitle("\u30eb\u30fc\u30eb\u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210");
        this.setDescription("\u65b0\u3057\u3044\u30eb\u30fc\u30eb\u30d5\u30a1\u30a4\u30eb\uff08drl\uff09\u3092\u4f5c\u6210\u3059\u308b\u3002");
        this.workbench = iWorkbench;
    }

    protected void createAdvancedControls(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.setControl((Control)composite2);
        this.createType(composite2);
        this.createDSL(composite2);
        this.createFunctions(composite2);
        this.createPackageName(composite2);
        super.createAdvancedControls(composite);
    }

    protected boolean validatePage() {
        return super.validatePage() && this.validate();
    }

    private void createPackageName(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("\u30eb\u30fc\u30eb\u30d1\u30c3\u30b1\u30fc\u30b8\u540d\uff1a");
        label.setLayoutData((Object)new GridData(128));
        label.setFont(this.getFont());
        this.packageName = new Text(composite, 2048);
        this.packageName.setLayoutData((Object)new GridData(768));
        this.packageName.setToolTipText("\u30eb\u30fc\u30eb\u306b\u306f\u540d\u524d\u7a7a\u9593\u304c\u5fc5\u8981\u3067\u3059\u3002");
        this.packageName.setFont(this.getFont());
        this.packageName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewRulePackagePage.this.setPageComplete(NewRulePackagePage.this.validatePage());
            }
        });
    }

    private void createFunctions(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("\u95a2\u6570\u3092\u4f7f\u3046\uff1a");
        label.setLayoutData((Object)new GridData(128));
        label.setFont(this.getFont());
        this.function = new Button(composite, 32);
        this.function.setSelection(false);
        this.function.setLayoutData((Object)new GridData(32));
        this.function.setToolTipText("\u95a2\u6570\u3068\u306f\u3001\u30eb\u30fc\u30eb\u30bd\u30fc\u30b9\u306b\u7d44\u307f\u8fbc\u3080\u30e1\u30bd\u30c3\u30c9\u3067\u3059\u3002");
    }

    private void createDSL(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("DSL\u3092\u4f7f\u3046\uff1a");
        label.setLayoutData((Object)new GridData(128));
        label.setFont(this.getFont());
        this.expander = new Button(composite, 32);
        this.expander.setSelection(false);
        this.expander.setLayoutData((Object)new GridData(32));
        this.expander.setToolTipText("\u30c9\u30e1\u30a4\u30f3\u56fa\u6709\u8a00\u8a9e\uff1a \u30eb\u30fc\u30eb\u3067\u4f7f\u3048\u308b\u30c9\u30e1\u30a4\u30f3\u56fa\u6709\u8a00\u8a9e\n\u3092\u4f5c\u6210\u3059\u308b\u3002");
    }

    private void createType(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("\u30eb\u30fc\u30eb\u30ea\u30bd\u30fc\u30b9\u306e\u30bf\u30a4\u30d7\uff1a");
        label.setFont(this.getFont());
        label.setLayoutData((Object)new GridData(128));
        this.ruleFileType = new Combo(composite, 8);
        this.ruleFileType.add("\u65b0\u3057\u3044DRL\uff08\u30eb\u30fc\u30eb\u30d1\u30c3\u30b1\u30fc\u30b8\uff09", 0);
        this.ruleFileType.add("\u65b0\u3057\u3044\u30eb\u30fc\u30eb\uff08\u500b\u5225\u306e\u30eb\u30fc\u30eb\uff09", 1);
        this.ruleFileType.select(0);
        this.ruleFileType.setLayoutData((Object)new GridData(768));
        this.ruleFileType.setFont(this.getFont());
    }

    public boolean finish() {
        IFile iFile;
        String string;
        if (!this.validate()) {
            return false;
        }
        String string2 = this.getFileName();
        String string3 = string = this.expander.getSelection() ? ".dslr" : ".drl";
        if (!string2.endsWith(string)) {
            this.setFileName(String.valueOf(string2) + string);
        }
        if ((iFile = this.createNewFile()) == null) {
            return false;
        }
        try {
            IWorkbenchWindow iWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            if (iWorkbenchPage != null) {
                IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
            }
        }
        catch (PartInitException partInitException) {
            DroolsEclipsePlugin.log(partInitException);
            return false;
        }
        return true;
    }

    private boolean validate() {
        if (this.packageName.getText() == null || this.packageName.getText().equals("")) {
            this.setErrorMessage("\u30eb\u30fc\u30eb\u30d1\u30c3\u30b1\u30fc\u30b8\u540d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return false;
        }
        return true;
    }

    protected InputStream getInitialContents() {
        try {
            DRLGenerator dRLGenerator = new DRLGenerator();
            if (this.ruleFileType.getSelectionIndex() == 1) {
                InputStream inputStream = this.getTemplate("org/drools/eclipse/wizard/rule/new_rule.drl.template");
                return dRLGenerator.generateRule(this.packageName.getText(), inputStream);
            }
            InputStream inputStream = this.getTemplate("org/drools/eclipse/wizard/rule/new_package.drl.template");
            return dRLGenerator.generatePackage(this.packageName.getText(), this.function.getSelection(), this.expander.getSelection(), inputStream);
        }
        catch (IOException iOException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private InputStream getTemplate(String string) throws IOException {
        return DroolsEclipsePlugin.getDefault().getBundle().getResource(string).openStream();
    }
}

