/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.ILocator;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.client.CollectionHandle;
import org.eclipse.webdav.client.DAVClient;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.client.PropertyStatus;
import org.eclipse.webdav.client.ResourceHandle;
import org.eclipse.webdav.client.ResponseInputStream;
import org.eclipse.webdav.client.URLTable;
import org.eclipse.webdav.client.URLTool;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.HrefSet;
import org.eclipse.webdav.dom.LockDiscovery;
import org.eclipse.webdav.dom.LockInfo;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.MultiStatus;
import org.eclipse.webdav.dom.Prop;
import org.eclipse.webdav.dom.PropFind;
import org.eclipse.webdav.dom.PropStat;
import org.eclipse.webdav.dom.PropertyBehavior;
import org.eclipse.webdav.dom.PropertyUpdate;
import org.eclipse.webdav.dom.QualifiedName;
import org.eclipse.webdav.dom.ResponseBody;
import org.eclipse.webdav.dom.Status;
import org.eclipse.webdav.dom.Update;
import org.eclipse.webdav.internal.kernel.ClientException;
import org.eclipse.webdav.internal.kernel.DAVException;
import org.eclipse.webdav.internal.kernel.LockToken;
import org.eclipse.webdav.internal.kernel.RedirectionException;
import org.eclipse.webdav.internal.kernel.ServerException;
import org.eclipse.webdav.internal.kernel.SystemException;
import org.eclipse.webdav.internal.kernel.WebDAVException;
import org.eclipse.webdav.internal.kernel.WebDAVPropertyNames;
import org.eclipse.webdav.internal.kernel.WebDAVPropertyValues;
import org.eclipse.webdav.internal.kernel.utils.Assert;
import org.eclipse.webdav.internal.kernel.utils.EmptyEnumeration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractResourceHandle
implements WebDAVPropertyNames,
WebDAVPropertyValues {
    protected DAVClient davClient;
    protected ILocator locator;

    public AbstractResourceHandle(DAVClient dAVClient, ILocator iLocator) {
        Assert.isNotNull(dAVClient);
        Assert.isNotNull(iLocator);
        this.davClient = dAVClient;
        this.locator = iLocator;
    }

    public CollectionHandle asCollectionHandle() {
        return new CollectionHandle(this.davClient, this.locator);
    }

    public ResourceHandle asResourceHandle() {
        return new ResourceHandle(this.davClient, this.locator);
    }

    public boolean canTalkDAV() throws DAVException {
        boolean bl;
        IResponse iResponse = null;
        try {
            iResponse = this.davClient.options(this.locator, this.newContext());
            this.examineResponse(iResponse);
            String string = iResponse.getContext().getDAV();
            bl = string != null && string.indexOf("1") != -1;
        }
        catch (IOException iOException) {
            try {
                throw new SystemException(iOException);
            }
            catch (Throwable throwable) {
                this.closeResponse(iResponse);
                throw throwable;
            }
        }
        this.closeResponse(iResponse);
        return bl;
    }

    public ResourceHandle checkIn() throws DAVException {
        ILocator iLocator = this.protectedCheckIn();
        return new ResourceHandle(this.davClient, iLocator);
    }

    public abstract AbstractResourceHandle checkOut() throws DAVException;

    protected void closeResponse(IResponse iResponse) throws SystemException {
        if (iResponse == null) {
            return;
        }
        try {
            iResponse.close();
        }
        catch (IOException iOException) {
            throw new SystemException(iOException);
        }
    }

    public void copy(ILocator iLocator) throws DAVException {
        this.copy(iLocator, "infinity", false, null);
    }

    public void copy(ILocator iLocator, String string, boolean bl, Collection collection) throws DAVException {
        IContext iContext = this.newContext();
        iContext.setDepth(string);
        iContext.setOverwrite(bl);
        Document document = this.newDocument();
        PropertyBehavior propertyBehavior = PropertyBehavior.create(document);
        if (collection == null) {
            propertyBehavior.setIsKeepAllAlive(true);
        } else {
            for (QualifiedName qualifiedName : collection) {
                String string2 = String.valueOf(qualifiedName.getQualifier()) + "/" + qualifiedName.getLocalName();
                propertyBehavior.addProperty(string2);
            }
        }
        Object object = null;
        try {
            try {
                object = this.davClient.copy(this.locator, iLocator, iContext, document);
                this.examineResponse((IResponse)object);
                this.examineMultiStatusResponse((IResponse)object);
            }
            catch (IOException iOException) {
                throw new SystemException(iOException);
            }
        }
        catch (Throwable throwable) {
            this.closeResponse((IResponse)object);
            throw throwable;
        }
        this.closeResponse((IResponse)object);
    }

    public abstract void create() throws DAVException;

    public void delete() throws DAVException {
        this.delete(false);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractResourceHandle)) {
            return false;
        }
        AbstractResourceHandle abstractResourceHandle = (AbstractResourceHandle)object;
        return this.locator.equals(abstractResourceHandle.locator);
    }

    public int hashCode() {
        return this.locator.hashCode();
    }

    protected void examineMultiStatusResponse(IResponse iResponse) throws DAVException {
        Element element;
        if (iResponse.getStatusCode() != 207) {
            return;
        }
        if (!iResponse.hasDocumentBody()) {
            throw new DAVException(Policy.bind("exception.responseMustHaveDocBody"));
        }
        try {
            element = iResponse.getDocumentBody().getDocumentElement();
            if (element == null) {
                throw new DAVException(Policy.bind("exception.invalidDoc"));
            }
        }
        catch (IOException iOException) {
            throw new SystemException(iOException);
        }
        try {
            MultiStatus multiStatus = new MultiStatus(element);
            Enumeration enumeration = multiStatus.getResponses();
            while (enumeration.hasMoreElements()) {
                ResponseBody responseBody = (ResponseBody)enumeration.nextElement();
                Enumeration enumeration2 = responseBody.getPropStats();
                while (enumeration2.hasMoreElements()) {
                    PropStat propStat = (PropStat)enumeration2.nextElement();
                    this.examineStatusCode(propStat.getStatusCode(), propStat.getResponseDescription());
                }
            }
        }
        catch (MalformedElementException malformedElementException) {
            throw new SystemException(malformedElementException);
        }
    }

    protected void examineResponse(IResponse iResponse) throws WebDAVException {
        this.examineStatusCode(iResponse.getStatusCode(), iResponse.getStatusMessage());
    }

    protected URLTable extractPropStats(MultiStatus multiStatus) throws IOException, MalformedElementException {
        URLTable uRLTable = new URLTable();
        Enumeration enumeration = multiStatus.getResponses();
        while (enumeration.hasMoreElements()) {
            ResponseBody responseBody = (ResponseBody)enumeration.nextElement();
            String string = responseBody.getHref();
            URL uRL = new URL(new URL(this.locator.getResourceURL()), string);
            Hashtable<QualifiedName, PropertyStatus> hashtable = new Hashtable<QualifiedName, PropertyStatus>();
            uRLTable.put(uRL, hashtable);
            Enumeration enumeration2 = responseBody.getPropStats();
            while (enumeration2.hasMoreElements()) {
                PropStat propStat = (PropStat)enumeration2.nextElement();
                Status status = new Status(propStat.getStatus());
                Enumeration enumeration3 = propStat.getProp().getProperties();
                while (enumeration3.hasMoreElements()) {
                    Element element = (Element)enumeration3.nextElement();
                    QualifiedName qualifiedName = ElementEditor.getQualifiedName(element);
                    PropertyStatus propertyStatus = new PropertyStatus(element, status.getStatusCode(), status.getStatusMessage());
                    hashtable.put(qualifiedName, propertyStatus);
                }
            }
        }
        return uRLTable;
    }

    public ResponseInputStream getContent() throws DAVException {
        IResponse iResponse = null;
        try {
            iResponse = this.davClient.get(this.locator, this.newContext());
            this.examineResponse(iResponse);
        }
        catch (IOException iOException) {
            this.closeResponse(iResponse);
            throw new SystemException(iOException);
        }
        return new ResponseInputStream(iResponse);
    }

    public DAVClient getDAVClient() {
        return this.davClient;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public Enumeration getLocks() throws DAVException {
        LockDiscovery lockDiscovery = null;
        try {
            Element element = this.getProperty(DAV_LOCK_DISCOVERY).getProperty();
            lockDiscovery = new LockDiscovery(element);
            return lockDiscovery.getActiveLocks();
        }
        catch (WebDAVException webDAVException) {
            if (webDAVException.getStatusCode() == 404) {
                return new EmptyEnumeration();
            }
            throw webDAVException;
        }
        catch (MalformedElementException malformedElementException) {
            throw new SystemException(malformedElementException);
        }
    }

    public CollectionHandle getParent() throws DAVException {
        URL uRL;
        block3: {
            Assert.isTrue(this.locator.getLabel() == null);
            Assert.isTrue(!this.locator.isStable());
            try {
                uRL = URLTool.getParent(this.locator.getResourceURL());
                if (uRL != null) break block3;
                return null;
            }
            catch (MalformedURLException malformedURLException) {
                throw new SystemException(malformedURLException);
            }
        }
        String string = uRL.toString();
        ILocator iLocator = this.davClient.getDAVFactory().newLocator(string);
        return new CollectionHandle(this.davClient, iLocator);
    }

    public URLTable getProperties(String string) throws DAVException {
        return this.getProperties(null, string);
    }

    public URLTable getProperties(Collection collection, String string) throws DAVException {
        Object object;
        Object object2;
        IContext iContext = this.newContext();
        iContext.setDepth(string);
        Document document = this.newDocument();
        PropFind propFind = PropFind.create(document);
        if (collection == null) {
            propFind.setIsAllProp(true);
        } else {
            object2 = propFind.setProp();
            object = collection.iterator();
            while (object.hasNext()) {
                ((Prop)object2).addPropertyName((QualifiedName)object.next());
            }
        }
        object2 = null;
        try {
            object2 = this.davClient.propfind(this.locator, iContext, document);
            this.examineResponse((IResponse)object2);
            if (!object2.hasDocumentBody()) {
                throw new DAVException(Policy.bind("exception.respMustShareXMLDoc"));
            }
            object = object2.getDocumentBody().getDocumentElement();
            if (object == null) {
                throw new DAVException(Policy.bind("exception.respHasInvalidDoc"));
            }
            MultiStatus multiStatus = new MultiStatus((Element)object);
            URLTable uRLTable = this.extractPropStats(multiStatus);
            return uRLTable;
        }
        catch (IOException iOException) {
            throw new SystemException(iOException);
        }
        catch (MalformedElementException malformedElementException) {
            throw new SystemException(malformedElementException);
        }
        finally {
            this.closeResponse((IResponse)object2);
        }
    }

    public PropertyStatus getProperty(QualifiedName qualifiedName) throws DAVException {
        HashSet<QualifiedName> hashSet = new HashSet<QualifiedName>();
        hashSet.add(qualifiedName);
        URLTable uRLTable = this.getProperties(hashSet, "0");
        URL uRL = null;
        try {
            uRL = new URL(this.locator.getResourceURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw new SystemException(malformedURLException);
        }
        Hashtable hashtable = (Hashtable)uRLTable.get(uRL);
        if (hashtable == null) {
            throw new DAVException(Policy.bind("exception.lookup", uRL.toExternalForm()));
        }
        return (PropertyStatus)hashtable.get(qualifiedName);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URLTable getPropertyNames(String string) throws DAVException {
        URLTable uRLTable;
        IContext iContext = this.newContext();
        iContext.setDepth(string);
        IResponse iResponse = null;
        try {
            Document document = this.newDocument();
            PropFind propFind = PropFind.create(document);
            propFind.setIsPropName(true);
            iResponse = this.davClient.propfind(this.locator, iContext, document);
            this.examineResponse(iResponse);
            if (!iResponse.hasDocumentBody()) {
                throw new DAVException(Policy.bind("exception.respMustHaveElmtBody"));
            }
            Element element = iResponse.getDocumentBody().getDocumentElement();
            if (element == null) {
                throw new DAVException(Policy.bind("exception.bodyMustHaveElmt"));
            }
            MultiStatus multiStatus = new MultiStatus(element);
            URLTable uRLTable2 = new URLTable(10);
            Enumeration enumeration = multiStatus.getResponses();
            while (enumeration.hasMoreElements()) {
                ResponseBody responseBody = (ResponseBody)enumeration.nextElement();
                String string2 = responseBody.getHref();
                URL uRL = new URL(new URL(this.locator.getResourceURL()), string2);
                Enumeration enumeration2 = responseBody.getPropStats();
                Vector<QualifiedName> vector = new Vector<QualifiedName>();
                while (enumeration2.hasMoreElements()) {
                    PropStat propStat = (PropStat)enumeration2.nextElement();
                    Prop prop = propStat.getProp();
                    Enumeration enumeration3 = prop.getPropertyNames();
                    while (enumeration3.hasMoreElements()) {
                        QualifiedName qualifiedName = (QualifiedName)enumeration3.nextElement();
                        vector.addElement(qualifiedName);
                    }
                }
                uRLTable2.put(uRL, vector.elements());
            }
            uRLTable = uRLTable2;
        }
        catch (IOException iOException) {
            try {
                throw new SystemException(iOException);
                catch (MalformedElementException malformedElementException) {
                    throw new SystemException(malformedElementException);
                }
            }
            catch (Throwable throwable) {
                this.closeResponse(iResponse);
                throw throwable;
            }
        }
        this.closeResponse(iResponse);
        return uRLTable;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URLTable getVersionTree() throws DAVException {
        URLTable uRLTable;
        Document document = this.newDocument();
        Element element = ElementEditor.create(document, "version-tree");
        Element element2 = ElementEditor.appendChild(element, "prop");
        ElementEditor.appendChild(element2, "predecessor-set");
        IResponse iResponse = null;
        try {
            iResponse = this.davClient.report(this.locator, this.newContext(), document);
            this.examineResponse(iResponse);
            if (!iResponse.hasDocumentBody()) {
                throw new DAVException(Policy.bind("exception.respMustHaveElmtBody"));
            }
            Element element3 = iResponse.getDocumentBody().getDocumentElement();
            if (element3 == null) {
                throw new DAVException(Policy.bind("exception.bodyMustHaveElmt"));
            }
            MultiStatus multiStatus = new MultiStatus(element3);
            URLTable uRLTable2 = new URLTable();
            Enumeration enumeration = multiStatus.getResponses();
            while (enumeration.hasMoreElements()) {
                ResponseBody responseBody = (ResponseBody)enumeration.nextElement();
                String string = responseBody.getHref();
                URL uRL = new URL(new URL(this.locator.getResourceURL()), string);
                Vector<URL> vector = new Vector<URL>();
                uRLTable2.put(uRL, vector);
                Enumeration enumeration2 = responseBody.getPropStats();
                while (enumeration2.hasMoreElements()) {
                    PropStat propStat = (PropStat)enumeration2.nextElement();
                    if (propStat.getStatusCode() != 200) {
                        throw new DAVException(Policy.bind("exception.errorRetrievingProp"));
                    }
                    Prop prop = propStat.getProp();
                    Enumeration enumeration3 = prop.getProperties();
                    while (enumeration3.hasMoreElements()) {
                        Element element4 = (Element)enumeration3.nextElement();
                        QualifiedName qualifiedName = ElementEditor.getQualifiedName(element4);
                        if (!qualifiedName.equals(DAV_PREDECESSOR_SET)) continue;
                        Enumeration enumeration4 = new HrefSet(element4, DAV_PREDECESSOR_SET).getHrefs();
                        while (enumeration4.hasMoreElements()) {
                            URL uRL2 = new URL((String)enumeration4.nextElement());
                            vector.add(uRL2);
                        }
                    }
                }
            }
            uRLTable = uRLTable2;
        }
        catch (IOException iOException) {
            try {
                throw new SystemException(iOException);
                catch (MalformedElementException malformedElementException) {
                    throw new SystemException(malformedElementException);
                }
            }
            catch (Throwable throwable) {
                this.closeResponse(iResponse);
                throw throwable;
            }
        }
        this.closeResponse(iResponse);
        return uRLTable;
    }

    public CollectionHandle[] getWorkspaceCollections() throws DAVException {
        Object[] objectArray;
        PropertyStatus propertyStatus = this.getProperty(DAV_WORKSPACE_COLLECTION_SET);
        Vector<CollectionHandle> vector = new Vector<CollectionHandle>(5);
        Element element = propertyStatus.getProperty();
        if (!ElementEditor.isDAVElement(element, "workspace-collection-set")) {
            throw new DAVException(Policy.bind("exception.malformedElement"));
        }
        Element element2 = ElementEditor.getFirstChild(element, "href");
        while (element2 != null) {
            objectArray = ElementEditor.getFirstText(element2);
            ILocator iLocator = this.davClient.getDAVFactory().newLocator((String)objectArray);
            vector.addElement(new CollectionHandle(this.davClient, iLocator));
            element2 = ElementEditor.getNextSibling(element2);
        }
        objectArray = new CollectionHandle[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public IContext head() throws DAVException {
        IContext iContext;
        IResponse iResponse = null;
        try {
            iResponse = this.davClient.head(this.locator, this.newContext());
            this.examineResponse(iResponse);
            iContext = iResponse.getContext();
        }
        catch (IOException iOException) {
            try {
                throw new SystemException(iOException);
            }
            catch (Throwable throwable) {
                this.closeResponse(iResponse);
                throw throwable;
            }
        }
        this.closeResponse(iResponse);
        return iContext;
    }

    public boolean isCollection() throws DAVException {
        return this.propertyHasChild(DAV_RESOURCE_TYPE, DAV_COLLECTION_RESOURCE_TYPE);
    }

    public boolean isLocked() throws DAVException {
        return this.getLocks().hasMoreElements();
    }

    public LockToken lock() throws DAVException {
        return this.lock(false, "0", -1, null);
    }

    public LockToken lock(boolean bl, String string, int n, String string2) throws DAVException {
        Object object;
        IContext iContext = this.newContext();
        iContext.setDepth(string);
        iContext.setTimeout(n);
        Document document = this.newDocument();
        LockInfo lockInfo = LockInfo.create(document);
        lockInfo.setIsShared(bl);
        if (string2 != null) {
            object = lockInfo.setOwner();
            ((ElementEditor)object).getElement().appendChild(document.createTextNode(string2));
        }
        object = null;
        try {
            try {
                object = this.davClient.lock(this.locator, iContext, document);
                this.examineResponse((IResponse)object);
            }
            catch (IOException iOException) {
                throw new SystemException(iOException);
            }
        }
        finally {
            this.closeResponse((IResponse)object);
        }
        LockToken lockToken = new LockToken(object.getContext().getLockToken());
        return lockToken;
    }

    public void move(ILocator iLocator) throws DAVException {
        this.move(iLocator, false, null);
    }

    /*
     * Unable to fully structure code
     */
    public void move(ILocator var1_1, boolean var2_2, Enumeration var3_3) throws DAVException {
        block6: {
            var4_4 = this.newContext();
            var4_4.setOverwrite(var2_2);
            var5_5 = this.newDocument();
            var6_6 = PropertyBehavior.create(var5_5);
            if (var3_3 != null) ** GOTO lbl12
            var6_6.setIsKeepAllAlive(true);
            break block6;
lbl-1000:
            // 1 sources

            {
                var7_7 = (IResponse)var3_3.nextElement();
                Assert.isTrue(var7_7 instanceof QualifiedName, Policy.bind("assert.propNameMustBeEnumOverQual"));
                var6_6.addProperty(((QualifiedName)var7_7).getLocalName());
lbl12:
                // 2 sources

                ** while (var3_3.hasMoreElements())
            }
        }
        var7_7 = null;
        try {
            try {
                var7_7 = this.davClient.move(this.locator, var1_1, var4_4, var5_5);
                this.examineResponse(var7_7);
                this.examineMultiStatusResponse(var7_7);
            }
            catch (IOException var8_8) {
                throw new SystemException(var8_8);
            }
        }
        catch (Throwable var9_9) {
            this.closeResponse(var7_7);
            throw var9_9;
        }
        this.closeResponse(var7_7);
    }

    protected IContext newContext() {
        return this.davClient.getDAVFactory().newContext();
    }

    protected Document newDocument() {
        return this.davClient.getDAVFactory().newDocument();
    }

    protected ILocator protectedCheckIn() throws DAVException {
        ILocator iLocator;
        IResponse iResponse = null;
        try {
            iResponse = this.davClient.checkin(this.locator, this.newContext(), null);
            this.examineResponse(iResponse);
            String string = iResponse.getContext().getLocation();
            iLocator = this.davClient.getDAVFactory().newStableLocator(string);
        }
        catch (IOException iOException) {
            try {
                throw new SystemException(iOException);
            }
            catch (Throwable throwable) {
                this.closeResponse(iResponse);
                throw throwable;
            }
        }
        this.closeResponse(iResponse);
        return iLocator;
    }

    protected ILocator protectedCheckOut() throws DAVException {
        ILocator iLocator;
        IResponse iResponse = null;
        try {
            iResponse = this.davClient.checkout(this.locator, this.newContext(), null);
            this.examineResponse(iResponse);
            String string = iResponse.getContext().getLocation();
            iLocator = this.davClient.getDAVFactory().newStableLocator(string);
        }
        catch (IOException iOException) {
            try {
                throw new SystemException(iOException);
            }
            catch (Throwable throwable) {
                this.closeResponse(iResponse);
                throw throwable;
            }
        }
        this.closeResponse(iResponse);
        return iLocator;
    }

    public void refreshLock(LockToken lockToken, int n) throws DAVException {
        IContext iContext = this.newContext();
        iContext.setTimeout(n);
        iContext.setLockToken(lockToken.getToken());
        IResponse iResponse = null;
        try {
            try {
                iResponse = this.davClient.lock(this.locator, iContext, null);
                this.examineResponse(iResponse);
            }
            catch (IOException iOException) {
                throw new SystemException(iOException);
            }
        }
        catch (Throwable throwable) {
            this.closeResponse(iResponse);
            throw throwable;
        }
        this.closeResponse(iResponse);
    }

    public void removeProperties(Collection collection) throws DAVException {
        Assert.isNotNull(collection);
        if (collection.isEmpty()) {
            return;
        }
        Document document = this.newDocument();
        PropertyUpdate propertyUpdate = PropertyUpdate.create(document);
        Prop prop = propertyUpdate.addRemove();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            prop.addPropertyName((QualifiedName)iterator.next());
        }
        IResponse iResponse = null;
        try {
            try {
                iResponse = this.davClient.proppatch(this.locator, this.newContext(), document);
                this.examineResponse(iResponse);
                this.examineMultiStatusResponse(iResponse);
            }
            catch (IOException iOException) {
                throw new SystemException(iOException);
            }
        }
        catch (Throwable throwable) {
            this.closeResponse(iResponse);
            throw throwable;
        }
        this.closeResponse(iResponse);
    }

    public void removeProperty(QualifiedName qualifiedName) throws DAVException {
        Vector<QualifiedName> vector = new Vector<QualifiedName>(1);
        vector.add(qualifiedName);
        this.removeProperties(vector);
    }

    public void setContent(InputStream inputStream) throws DAVException {
        this.setContent("application/octet-stream", inputStream);
    }

    public void setContent(String string, InputStream inputStream) throws DAVException {
        IResponse iResponse = null;
        try {
            try {
                IContext iContext = this.newContext();
                iContext.setContentType(string);
                iResponse = this.davClient.put(this.locator, iContext, inputStream);
                this.examineResponse(iResponse);
            }
            catch (IOException iOException) {
                throw new SystemException(iOException);
            }
        }
        catch (Throwable throwable) {
            this.closeResponse(iResponse);
            throw throwable;
        }
        this.closeResponse(iResponse);
    }

    public void setProperties(Collection collection) throws DAVException {
        Object object2;
        Assert.isNotNull(collection);
        if (collection.isEmpty()) {
            return;
        }
        Document document = this.newDocument();
        PropertyUpdate propertyUpdate = PropertyUpdate.create(document);
        Prop prop = propertyUpdate.addSet();
        for (Object object2 : collection) {
            try {
                prop.addProperty((Element)object2);
            }
            catch (MalformedElementException malformedElementException) {
                throw new SystemException(malformedElementException);
            }
        }
        object2 = null;
        try {
            try {
                object2 = this.davClient.proppatch(this.locator, this.newContext(), document);
                this.examineResponse((IResponse)object2);
                this.examineMultiStatusResponse((IResponse)object2);
            }
            catch (IOException iOException) {
                throw new SystemException(iOException);
            }
        }
        finally {
            this.closeResponse((IResponse)object2);
        }
    }

    public void setProperty(Element element) throws DAVException {
        Vector<Element> vector = new Vector<Element>(1);
        vector.add(element);
        this.setProperties(vector);
    }

    public String toString() {
        return this.locator.getResourceURL();
    }

    public ResponseInputStream trace() throws DAVException {
        IResponse iResponse = null;
        try {
            iResponse = this.davClient.trace(this.locator, this.newContext());
            this.examineResponse(iResponse);
        }
        catch (IOException iOException) {
            throw new SystemException(iOException);
        }
        catch (DAVException dAVException) {
            this.closeResponse(iResponse);
            throw dAVException;
        }
        return new ResponseInputStream(iResponse);
    }

    public void unlock(LockToken lockToken) throws DAVException {
        IContext iContext = this.newContext();
        iContext.setLockToken("<" + lockToken.getToken() + ">");
        IResponse iResponse = null;
        try {
            try {
                iResponse = this.davClient.unlock(this.locator, iContext);
                this.examineResponse(iResponse);
            }
            catch (IOException iOException) {
                throw new SystemException(iOException);
            }
        }
        catch (Throwable throwable) {
            this.closeResponse(iResponse);
            throw throwable;
        }
        this.closeResponse(iResponse);
    }

    public void update(ILocator iLocator) throws DAVException {
        Document document = this.newDocument();
        Update.createVersion(document, iLocator.getResourceURL());
        IResponse iResponse = null;
        try {
            try {
                iResponse = this.davClient.update(this.locator, this.newContext(), document);
                this.examineResponse(iResponse);
            }
            catch (IOException iOException) {
                throw new SystemException(iOException);
            }
        }
        catch (Throwable throwable) {
            this.closeResponse(iResponse);
            throw throwable;
        }
        this.closeResponse(iResponse);
    }

    public void versionControl() throws DAVException {
        IResponse iResponse = null;
        try {
            try {
                iResponse = this.davClient.versionControl(this.locator, this.newContext(), null);
                this.examineResponse(iResponse);
            }
            catch (IOException iOException) {
                throw new SystemException(iOException);
            }
        }
        catch (Throwable throwable) {
            this.closeResponse(iResponse);
            throw throwable;
        }
        this.closeResponse(iResponse);
    }

    public void delete(boolean bl) throws DAVException {
        IResponse iResponse;
        block5: {
            iResponse = null;
            iResponse = this.davClient.delete(this.locator, this.newContext());
            if (bl || iResponse.getStatusCode() != 404) break block5;
            this.closeResponse(iResponse);
            return;
        }
        try {
            try {
                this.examineResponse(iResponse);
                this.examineMultiStatusResponse(iResponse);
            }
            catch (IOException iOException) {
                throw new SystemException(iOException);
            }
        }
        catch (Throwable throwable) {
            this.closeResponse(iResponse);
            throw throwable;
        }
        this.closeResponse(iResponse);
    }

    protected void examineStatusCode(int n, String string) throws WebDAVException {
        if (n >= 300 && n <= 399) {
            throw new RedirectionException(n, string);
        }
        if (n >= 400 && n <= 499) {
            throw new ClientException(n, string);
        }
        if (n >= 500 && n <= 599) {
            throw new ServerException(n, string);
        }
    }

    public boolean exists() throws DAVException {
        IResponse iResponse;
        block5: {
            iResponse = null;
            iResponse = this.davClient.head(this.locator, this.newContext());
            if (iResponse.getStatusCode() != 404) break block5;
            this.closeResponse(iResponse);
            return false;
        }
        try {
            this.examineResponse(iResponse);
        }
        catch (IOException iOException) {
            try {
                throw new SystemException(iOException);
            }
            catch (Throwable throwable) {
                this.closeResponse(iResponse);
                throw throwable;
            }
        }
        this.closeResponse(iResponse);
        return true;
    }

    public boolean isCheckedIn() throws DAVException {
        return this.supportsLiveProperty(DAV_CHECKED_IN);
    }

    public boolean isCheckedOut() throws DAVException {
        return this.supportsLiveProperty(DAV_CHECKED_OUT);
    }

    public boolean isVersion() throws DAVException {
        return this.supportsLiveProperty(DAV_VERSION_NAME);
    }

    public boolean isVersionControlled() throws DAVException {
        return this.supportsLiveProperty(DAV_AUTO_CHECKOUT);
    }

    public boolean isWorkingResource() throws DAVException {
        PropertyStatus propertyStatus = this.getProperty(DAV_SUPPORTED_LIVE_PROPERTY_SET);
        if (propertyStatus.getStatusCode() == 404) {
            return false;
        }
        this.examineStatusCode(propertyStatus.getStatusCode(), propertyStatus.getStatusMessage());
        try {
            Element element = propertyStatus.getProperty();
            return ElementEditor.hasChild(element, DAV_CHECKED_OUT) && !ElementEditor.hasChild(element, DAV_AUTO_CHECKOUT);
        }
        catch (MalformedElementException malformedElementException) {
            throw new SystemException(malformedElementException);
        }
    }

    protected boolean propertyHasChild(QualifiedName qualifiedName, QualifiedName qualifiedName2) throws DAVException {
        PropertyStatus propertyStatus = this.getProperty(qualifiedName);
        if (propertyStatus.getStatusCode() == 404) {
            return false;
        }
        this.examineStatusCode(propertyStatus.getStatusCode(), propertyStatus.getStatusMessage());
        try {
            return ElementEditor.hasChild(propertyStatus.getProperty(), qualifiedName2);
        }
        catch (MalformedElementException malformedElementException) {
            throw new SystemException(malformedElementException);
        }
    }

    public boolean supportsLiveProperty(QualifiedName qualifiedName) throws DAVException {
        return this.propertyHasChild(DAV_SUPPORTED_LIVE_PROPERTY_SET, qualifiedName);
    }
}

