/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.client;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.ILocator;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.client.AbstractResourceHandle;
import org.eclipse.webdav.client.DAVClient;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.client.PropertyStatus;
import org.eclipse.webdav.client.ResourceHandle;
import org.eclipse.webdav.client.URLTable;
import org.eclipse.webdav.client.WorkspaceHandle;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.QualifiedName;
import org.eclipse.webdav.internal.kernel.DAVException;
import org.eclipse.webdav.internal.kernel.SystemException;
import org.eclipse.webdav.internal.kernel.utils.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CollectionHandle
extends AbstractResourceHandle {
    public CollectionHandle(DAVClient dAVClient, ILocator iLocator) {
        super(dAVClient, iLocator);
    }

    public void baselineControl() throws DAVException {
        IResponse iResponse = null;
        try {
            try {
                iResponse = this.davClient.baselineControl(this.locator, this.newContext(), null);
                this.examineResponse(iResponse);
            }
            catch (IOException iOException) {
                throw new SystemException(iOException);
            }
        }
        catch (Throwable throwable) {
            this.closeResponse(iResponse);
            throw throwable;
        }
        this.closeResponse(iResponse);
    }

    public void baselineControl(ILocator iLocator) throws DAVException {
        Assert.isNotNull(iLocator);
        Document document = this.newDocument();
        Element element = ElementEditor.create(document, "baseline-control");
        ElementEditor.addChild(element, "baseline", iLocator.getResourceURL(), new String[]{"baseline"}, true);
        IResponse iResponse = null;
        try {
            try {
                iResponse = this.davClient.baselineControl(this.locator, this.newContext(), document);
                this.examineResponse(iResponse);
            }
            catch (IOException iOException) {
                throw new SystemException(iOException);
            }
        }
        catch (Throwable throwable) {
            this.closeResponse(iResponse);
            throw throwable;
        }
        this.closeResponse(iResponse);
    }

    public void bind(String string, ILocator iLocator) throws DAVException {
        this.bind(string, iLocator, false);
    }

    public void bind(String string, ILocator iLocator, boolean bl) throws DAVException {
        IContext iContext = this.newContext();
        iContext.setOverwrite(bl);
        ILocator iLocator2 = this.getMember(string);
        IResponse iResponse = null;
        try {
            try {
                iResponse = this.davClient.bind(iLocator, iLocator2, iContext);
                this.examineResponse(iResponse);
            }
            catch (IOException iOException) {
                throw new SystemException(iOException);
            }
        }
        catch (Throwable throwable) {
            this.closeResponse(iResponse);
            throw throwable;
        }
        this.closeResponse(iResponse);
    }

    public AbstractResourceHandle checkOut() throws DAVException {
        ILocator iLocator = this.protectedCheckOut();
        return new CollectionHandle(this.davClient, iLocator);
    }

    public void create() throws DAVException {
        IResponse iResponse = null;
        try {
            try {
                iResponse = this.davClient.mkcol(this.locator, this.newContext(), null);
                this.examineResponse(iResponse);
            }
            catch (IOException iOException) {
                throw new SystemException(iOException);
            }
        }
        catch (Throwable throwable) {
            this.closeResponse(iResponse);
            throw throwable;
        }
        this.closeResponse(iResponse);
    }

    public void mkdirs() throws DAVException {
        this.mkdirs(this);
    }

    /*
     * Unable to fully structure code
     */
    protected void mkdirs(CollectionHandle var1_1) throws DAVException {
        block7: {
            var2_2 = null;
            var2_2 = this.davClient.mkcol(var1_1.locator, this.newContext(), null);
            var3_3 = var2_2.getStatusCode();
            if (var3_3 != 405 || !var1_1.isCollection()) break block7;
            while (true) {
                this.closeResponse(var2_2);
                return;
            }
        }
        try {
            try {
                if (var3_3 == 403 && var1_1.isCollection() && var1_1.exists()) ** continue;
                if (var3_3 == 409) {
                    this.closeResponse(var2_2);
                    var4_5 = var1_1.getParent();
                    this.mkdirs(var4_5);
                    var2_2 = this.davClient.mkcol(var1_1.locator, this.newContext(), null);
                }
                this.examineResponse(var2_2);
            }
            catch (IOException var3_4) {
                throw new SystemException(var3_4);
            }
        }
        catch (Throwable var5_6) {
            this.closeResponse(var2_2);
            throw var5_6;
        }
        this.closeResponse(var2_2);
    }

    public CollectionHandle getCollectionHandle(String string) throws DAVException {
        return new CollectionHandle(this.davClient, this.getMember(string));
    }

    public ILocator getMember(String string) {
        Assert.isTrue(this.locator.getLabel() == null);
        Assert.isTrue(!this.locator.isStable());
        String string2 = this.locator.getResourceURL();
        String string3 = string2.endsWith("/") ? String.valueOf(string2) + string : String.valueOf(string2) + "/" + string;
        return this.davClient.getDAVFactory().newLocator(string3);
    }

    public Set getMembers() throws DAVException {
        Vector<QualifiedName> vector = new Vector<QualifiedName>();
        vector.add(DAV_RESOURCE_TYPE);
        URLTable uRLTable = this.getProperties(vector, "1");
        HashSet<AbstractResourceHandle> hashSet = new HashSet<AbstractResourceHandle>();
        try {
            uRLTable.remove(this.locator.getResourceURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw new DAVException(Policy.bind("exception.malformedLocator"));
        }
        Enumeration enumeration = uRLTable.keys();
        while (enumeration.hasMoreElements()) {
            URL uRL = (URL)enumeration.nextElement();
            Hashtable hashtable = (Hashtable)uRLTable.get(uRL);
            Assert.isNotNull(hashtable);
            PropertyStatus propertyStatus = (PropertyStatus)hashtable.get(DAV_RESOURCE_TYPE);
            Assert.isNotNull(propertyStatus);
            ILocator iLocator = this.davClient.getDAVFactory().newLocator(uRL.toString());
            Element element = propertyStatus.getProperty();
            try {
                if (ElementEditor.hasChild(element, DAV_COLLECTION_RESOURCE_TYPE)) {
                    hashSet.add(new CollectionHandle(this.davClient, iLocator));
                    continue;
                }
                hashSet.add(new ResourceHandle(this.davClient, iLocator));
            }
            catch (MalformedElementException malformedElementException) {
                throw new SystemException(malformedElementException);
            }
        }
        return hashSet;
    }

    public ResourceHandle getResourceHandle(String string) throws DAVException {
        return new ResourceHandle(this.davClient, this.getMember(string));
    }

    public WorkspaceHandle getWorkspaceHandle(String string) throws DAVException {
        return new WorkspaceHandle(this.davClient, this.getMember(string));
    }

    public boolean isWorkspace() throws DAVException {
        return this.supportsLiveProperty(DAV_WORKSPACE_CHECKOUT_SET);
    }
}

