/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.ILocator;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.client.DAVClient;
import org.eclipse.webdav.client.RequestBodyWriter;
import org.eclipse.webdav.client.WebDAVFactory;
import org.eclipse.webdav.http.client.HttpClient;
import org.eclipse.webdav.http.client.Request;
import org.eclipse.webdav.internal.kernel.utils.Assert;
import org.eclipse.webdav.internal.utils.URLEncoder;
import org.w3c.dom.Document;

public class RemoteDAVClient
extends DAVClient {
    protected HttpClient httpClient = null;

    public RemoteDAVClient(RemoteDAVClient remoteDAVClient) {
        super(remoteDAVClient);
    }

    public RemoteDAVClient(WebDAVFactory webDAVFactory, HttpClient httpClient) {
        super(webDAVFactory);
        this.httpClient = httpClient;
    }

    public IResponse baselineControl(ILocator iLocator, IContext iContext, Document document) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, document, "BASELINE-CONTROL");
        return this.httpClient.invoke(request);
    }

    public IResponse bind(ILocator iLocator, ILocator iLocator2, IContext iContext) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iLocator2);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        iContext2.setDestination(URLEncoder.encode(iLocator2.getResourceURL()));
        Request request = this.newRequest(iLocator, iContext2, "BIND");
        return this.httpClient.invoke(request);
    }

    public IResponse checkin(ILocator iLocator, IContext iContext, Document document) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, document, "CHECKIN");
        return this.httpClient.invoke(request);
    }

    public IResponse checkout(ILocator iLocator, IContext iContext, Document document) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, document, "CHECKOUT");
        return this.httpClient.invoke(request);
    }

    protected Object clone() {
        return new RemoteDAVClient(this);
    }

    public void close() {
        this.httpClient.close();
        super.close();
    }

    public IResponse copy(ILocator iLocator, ILocator iLocator2, IContext iContext, Document document) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iLocator2);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        iContext2.setDestination(URLEncoder.encode(iLocator2.getResourceURL()));
        Request request = this.newRequest(iLocator, iContext2, document, "COPY");
        return this.httpClient.invoke(request);
    }

    public IResponse delete(ILocator iLocator, IContext iContext) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, "DELETE");
        return this.httpClient.invoke(request);
    }

    public IResponse get(ILocator iLocator, IContext iContext) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, "GET");
        return this.httpClient.invoke(request);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public IResponse head(ILocator iLocator, IContext iContext) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, "HEAD");
        return this.httpClient.invoke(request);
    }

    public IResponse label(ILocator iLocator, IContext iContext, Document document) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        Assert.isNotNull(document);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, document, "LABEL");
        return this.httpClient.invoke(request);
    }

    public IResponse lock(ILocator iLocator, IContext iContext, Document document) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, document, "LOCK");
        return this.httpClient.invoke(request);
    }

    public IResponse merge(ILocator iLocator, IContext iContext, Document document) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        Assert.isNotNull(document);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, document, "MERGE");
        return this.httpClient.invoke(request);
    }

    public IResponse mkactivity(ILocator iLocator, IContext iContext, Document document) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, document, "MKACTIVITY");
        return this.httpClient.invoke(request);
    }

    public IResponse mkcol(ILocator iLocator, IContext iContext, Document document) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, document, "MKCOL");
        return this.httpClient.invoke(request);
    }

    public IResponse mkworkspace(ILocator iLocator, IContext iContext, Document document) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, document, "MKWORKSPACE");
        return this.httpClient.invoke(request);
    }

    public IResponse move(ILocator iLocator, ILocator iLocator2, IContext iContext, Document document) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iLocator2);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        iContext2.setDestination(URLEncoder.encode(iLocator2.getResourceURL()));
        Request request = this.newRequest(iLocator, iContext2, document, "MOVE");
        return this.httpClient.invoke(request);
    }

    private Request newRequest(ILocator iLocator, IContext iContext, InputStream inputStream, String string) throws IOException {
        return new Request(string, URLEncoder.encode(new URL(iLocator.getResourceURL())), iContext, inputStream);
    }

    private Request newRequest(ILocator iLocator, IContext iContext, String string) throws IOException {
        return new Request(string, URLEncoder.encode(new URL(iLocator.getResourceURL())), iContext);
    }

    private Request newRequest(ILocator iLocator, IContext iContext, Document document, String string) throws IOException {
        iContext.setContentType("text/xml; charset=\"UTF8\"");
        if (document == null) {
            return new Request(string, URLEncoder.encode(new URL(iLocator.getResourceURL())), iContext);
        }
        RequestBodyWriter requestBodyWriter = new RequestBodyWriter(document, "UTF8");
        return new Request(string, URLEncoder.encode(new URL(iLocator.getResourceURL())), iContext, requestBodyWriter);
    }

    public IResponse options(ILocator iLocator, IContext iContext) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, "OPTIONS");
        return this.httpClient.invoke(request);
    }

    public IResponse post(ILocator iLocator, IContext iContext, InputStream inputStream) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        Assert.isNotNull(inputStream);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, inputStream, "POST");
        return this.httpClient.invoke(request);
    }

    public IResponse propfind(ILocator iLocator, IContext iContext, Document document) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, document, "PROPFIND");
        return this.httpClient.invoke(request);
    }

    public IResponse proppatch(ILocator iLocator, IContext iContext, Document document) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        Assert.isNotNull(document);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, document, "PROPPATCH");
        return this.httpClient.invoke(request);
    }

    public IResponse put(ILocator iLocator, IContext iContext, InputStream inputStream) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        Assert.isNotNull(inputStream);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, inputStream, "PUT");
        return this.httpClient.invoke(request);
    }

    public IResponse report(ILocator iLocator, IContext iContext, Document document) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        Assert.isNotNull(document);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, document, "REPORT");
        return this.httpClient.invoke(request);
    }

    public IResponse trace(ILocator iLocator, IContext iContext) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, "TRACE");
        return this.httpClient.invoke(request);
    }

    public IResponse uncheckout(ILocator iLocator, IContext iContext) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, "UNCHECKOUT");
        return this.httpClient.invoke(request);
    }

    public IResponse unlock(ILocator iLocator, IContext iContext) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, "UNLOCK");
        return this.httpClient.invoke(request);
    }

    public IResponse update(ILocator iLocator, IContext iContext, Document document) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, document, "UPDATE");
        return this.httpClient.invoke(request);
    }

    public IResponse versionControl(ILocator iLocator, IContext iContext, Document document) throws IOException {
        Assert.isNotNull(iLocator);
        Assert.isNotNull(iContext);
        IContext iContext2 = this.newContext(iContext, iLocator);
        Request request = this.newRequest(iLocator, iContext2, document, "VERSION-CONTROL");
        return this.httpClient.invoke(request);
    }
}

