/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.webdav.client.URLTool;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class URLTable {
    private Hashtable table;

    public URLTable() {
        this.table = new Hashtable();
    }

    public URLTable(int n) {
        this.table = new Hashtable(n);
    }

    public Object get(String string) throws MalformedURLException {
        Assert.isNotNull(string);
        return this.get(new URL(string));
    }

    public Object get(URL uRL) {
        Assert.isNotNull(uRL);
        return this.get(new URLKey(uRL));
    }

    private Object get(URLKey uRLKey) {
        Assert.isNotNull(uRLKey);
        return this.table.get(uRLKey);
    }

    public Enumeration keys() {
        final Enumeration enumeration = this.table.keys();
        Enumeration enumeration2 = new Enumeration(){

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            public Object nextElement() {
                return ((URLKey)enumeration.nextElement()).getURL();
            }
        };
        return enumeration2;
    }

    public void put(String string, Object object) throws MalformedURLException {
        Assert.isNotNull(string);
        Assert.isNotNull(object);
        this.put(new URL(string), object);
    }

    public void put(URL uRL, Object object) {
        Assert.isNotNull(uRL);
        Assert.isNotNull(object);
        this.put(new URLKey(uRL), object);
    }

    private void put(URLKey uRLKey, Object object) {
        Assert.isNotNull(uRLKey);
        Assert.isNotNull(object);
        if (this.table.get(uRLKey) != null) {
            this.table.remove(uRLKey);
        }
        this.table.put(uRLKey, object);
    }

    public void remove(String string) throws MalformedURLException {
        Assert.isNotNull(string);
        this.remove(new URL(string));
    }

    public void remove(URL uRL) {
        Assert.isNotNull(uRL);
        this.remove(new URLKey(uRL));
    }

    private void remove(URLKey uRLKey) {
        Assert.isNotNull(uRLKey);
        this.table.remove(uRLKey);
    }

    class URLKey {
        URL url;
        int hashCode = -1;

        public URLKey(URL uRL) {
            this.url = uRL;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (object instanceof URLKey) {
                return this.equals(((URLKey)object).getURL());
            }
            if (object instanceof String) {
                try {
                    return this.equals(new URL((String)object));
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
            }
            if (!(object instanceof URL)) {
                return false;
            }
            if (this.url == (URL)object) {
                return true;
            }
            URL uRL = URLTool.removeTrailingSlash(this.url);
            URL uRL2 = URLTool.removeTrailingSlash((URL)object);
            return uRL.equals(uRL2);
        }

        public URL getURL() {
            return this.url;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = URLTool.removeTrailingSlash(this.url).hashCode();
            }
            return this.hashCode;
        }

        public String toString() {
            return this.url.toString();
        }
    }
}

