/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Owner;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ActiveLock
extends ElementEditor {
    protected static final String[] childNames = new String[]{"lockscope", "locktype", "depth", "owner", "timeout", "locktoken"};

    public ActiveLock(Element element) throws MalformedElementException {
        super(element, "activelock");
    }

    public void addLockTokenHref(String string) {
        Assert.isNotNull(string);
        Element element = ActiveLock.getLastChild(this.root, "locktoken");
        if (element == null) {
            element = ActiveLock.setChild(this.root, "locktoken", childNames, false);
        }
        ActiveLock.appendChild(element, "href", ActiveLock.encodeHref(string));
    }

    public String getDepth() throws MalformedElementException {
        String string = ActiveLock.getChildText(this.root, "depth", false);
        ActiveLock.ensureNotNull(Policy.bind("ensure.missingDepthElmt"), string);
        ActiveLock.ensure(string.equals("0") || string.equals("1") || string.equals("infinity"), Policy.bind("ensure.invalidDepth", string));
        return string;
    }

    public Enumeration getLockTokenHrefs() throws MalformedElementException {
        Element element = ActiveLock.getLastChild(this.root, "locktoken");
        Element element2 = null;
        if (element != null) {
            element2 = ActiveLock.getFirstChild(element, "href");
            ActiveLock.ensureNotNull(Policy.bind("ensure.missingHrefElmt"), element2);
        }
        Element element3 = element2;
        Enumeration enumeration = new Enumeration(element3){
            Node currentHref;
            {
                this.currentHref = node;
            }

            public boolean hasMoreElements() {
                return this.currentHref != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String string = ActiveLock.getFirstText((Element)this.currentHref);
                this.currentHref = ActiveLock.getTwin((Element)this.currentHref, true);
                return ActiveLock.decodeHref(string);
            }
        };
        return enumeration;
    }

    public Owner getOwner() throws MalformedElementException {
        Element element = ActiveLock.getLastChild(this.root, "owner");
        if (element == null) {
            return null;
        }
        return new Owner(element);
    }

    public String getTimeout() throws MalformedElementException {
        return ActiveLock.getChildText(this.root, "timeout", false);
    }

    public boolean isShared() throws MalformedElementException {
        Element element = ActiveLock.getFirstChild(this.root, "lockscope");
        ActiveLock.ensureNotNull(Policy.bind("ensure.missingLockscopeElmt "), element);
        String[] stringArray = new String[]{"shared", "exclusive"};
        Element element2 = ActiveLock.getFirstChild(element, stringArray);
        ActiveLock.ensureNotNull(Policy.bind("ensure.missingSharedOrExclusiveElmt"), element2);
        boolean bl = ActiveLock.isDAVElement(element2, "shared");
        ActiveLock.ensure(ActiveLock.getNextSibling(element2, stringArray) == null, Policy.bind("ensure.conflictingSharedOrExclusiveElmt"));
        return bl;
    }

    public void setDepth(String string) {
        Assert.isNotNull(string);
        Assert.isTrue(string.equals("0") || string.equals("1") || string.equals("infinity"));
        ActiveLock.setChild(this.root, "depth", string, childNames, false);
    }

    public void setIsShared(boolean bl) {
        Element element = ActiveLock.setChild(this.root, "lockscope", childNames, true);
        if (bl) {
            ActiveLock.appendChild(element, "shared");
        } else {
            ActiveLock.appendChild(element, "exclusive");
        }
    }

    public Owner setOwner() {
        Element element = ActiveLock.setChild(this.root, "owner", childNames, false);
        Owner owner = null;
        try {
            owner = new Owner(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return owner;
    }

    public void setTimeout(String string) {
        if (string == null) {
            Element element = ActiveLock.getLastChild(this.root, "timeout");
            if (element != null) {
                this.root.removeChild(element);
            }
        } else {
            ActiveLock.setChild(this.root, "timeout", string, childNames, false);
        }
    }
}

