/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Property;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Bindings
extends Property {
    protected static final String[] childNames = new String[]{"href", "segment"};

    public Bindings(Element element) throws MalformedElementException {
        super(element, "bindings");
    }

    public void addBinding(String string, String string2) {
        Assert.isNotNull(string);
        Assert.isNotNull(string2);
        Bindings.appendChild(this.root, "href", Bindings.encodeHref(string));
        Bindings.appendChild(this.root, "segment", string2);
    }

    public Enumeration getBindings() throws MalformedElementException {
        Element element = Bindings.getFirstChild(this.root, "href");
        Element element2 = null;
        if (element != null) {
            element2 = Bindings.getNextSibling(element, "segment");
        }
        Element element3 = element2;
        Enumeration enumeration = new Enumeration(element, element3){
            Node fCurrentHref;
            Node fCurrentSegment;
            {
                this.fCurrentHref = node;
                this.fCurrentSegment = node2;
            }

            public boolean hasMoreElements() {
                return this.fCurrentHref != null && this.fCurrentSegment != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String string = Bindings.getFirstText((Element)this.fCurrentHref);
                String string2 = Bindings.getFirstText((Element)this.fCurrentSegment);
                Binding binding = new Binding(Bindings.decodeHref(string), string2);
                this.fCurrentHref = Bindings.getNextSibling((Element)this.fCurrentSegment, "href");
                this.fCurrentSegment = null;
                if (this.fCurrentHref != null) {
                    this.fCurrentSegment = Bindings.getNextSibling((Element)this.fCurrentHref, "segment");
                }
                return binding;
            }
        };
        return enumeration;
    }

    public class Binding {
        private String fHref = null;
        private String fSegment = null;

        public Binding(String string, String string2) {
            Assert.isNotNull(string);
            Assert.isNotNull(string2);
            this.fHref = string;
            this.fSegment = string2;
        }

        public String getHref() {
            return this.fHref;
        }

        public String getSegment() {
            return this.fSegment;
        }
    }
}

