/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Namespaces;
import org.eclipse.webdav.dom.QualifiedName;
import org.eclipse.webdav.dom.QualifiedNameImpl;
import org.eclipse.webdav.internal.utils.URLDecoder;
import org.eclipse.webdav.internal.utils.URLEncoder;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class ElementEditor {
    protected Element root;
    protected static final String DAV_NS = "DAV:";
    protected static final String XML_PREFIX = "xmlns";
    protected static final String XML_NS_PREFIX = "xml";
    protected static final String XML_NS_NAME = "http://www.w3.org/XML/1998/namespace";

    protected ElementEditor(Element element) throws MalformedElementException {
        Assert.isNotNull(element);
        this.root = element;
    }

    protected ElementEditor(Element element, String string) throws MalformedElementException {
        Assert.isNotNull(element);
        Assert.isNotNull(string);
        this.root = element;
        ElementEditor.ensureDAVElement(element, string, Policy.bind("ensure.expectingAnElmt", string));
    }

    public static Element addChild(Element element, String string, String[] stringArray, boolean bl) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        Assert.isNotNull(string);
        Assert.isNotNull(stringArray);
        String string2 = ElementEditor.getNSPrefix(element);
        String string3 = string2 == null ? string : String.valueOf(string2) + ":" + string;
        Element element2 = element.getOwnerDocument().createElement(string3);
        ElementEditor.addChild(element, element2, stringArray, bl);
        return element2;
    }

    public static Element addChild(Element element, String string, String string2, String[] stringArray, boolean bl) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        Assert.isNotNull(string);
        Assert.isNotNull(string2);
        Assert.isNotNull(stringArray);
        Element element2 = ElementEditor.addChild(element, string, stringArray, bl);
        element2.appendChild(element2.getOwnerDocument().createTextNode(string2));
        return element2;
    }

    public static void addChild(Element element, Element element2, String[] stringArray, boolean bl) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        Assert.isNotNull(element2);
        Assert.isTrue(DAV_NS.equals(ElementEditor.resolve(ElementEditor.getNSPrefix(element2), element)));
        Assert.isNotNull(stringArray);
        boolean bl2 = false;
        String string = ElementEditor.getNSLocalName(element2);
        int n = 0;
        while (!bl2 && n < stringArray.length) {
            bl2 = stringArray[n].equals(string);
            ++n;
        }
        Assert.isTrue(bl2);
        Element element3 = ElementEditor.getChild(element, string, stringArray, bl);
        if (bl) {
            if (element3 == null) {
                element.appendChild(element2);
            } else {
                Element element4 = null;
                while (ElementEditor.isDAVElement(element3, string)) {
                    element4 = element3;
                    element3 = ElementEditor.getTwin(element3, bl);
                }
                if (element4 == null) {
                    element.insertBefore(element2, element3);
                } else {
                    Node node = element4.getNextSibling();
                    if (node == null) {
                        element.appendChild(element2);
                    } else {
                        element.insertBefore(element2, node);
                    }
                }
            }
        } else {
            Node node = null;
            node = element3 == null ? element.getFirstChild() : element3.getNextSibling();
            if (node == null) {
                element.appendChild(element2);
            } else {
                element.insertBefore(element2, node);
            }
        }
    }

    public static Element appendChild(Element element, String string) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        Assert.isNotNull(string);
        String string2 = ElementEditor.getNSPrefix(element);
        String string3 = string2 == null ? string : String.valueOf(string2) + ":" + string;
        Element element2 = element.getOwnerDocument().createElement(string3);
        element.appendChild(element2);
        return element2;
    }

    public static Element appendChild(Element element, String string, String string2) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        Assert.isNotNull(string);
        Assert.isNotNull(string2);
        Element element2 = ElementEditor.appendChild(element, string);
        element2.appendChild(element2.getOwnerDocument().createTextNode(string2));
        return element2;
    }

    public static Node cloneNode(Document document, Node node) {
        Node node2 = null;
        switch (node.getNodeType()) {
            case 1: {
                node2 = document.createElement(((Element)node).getTagName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Attr attr = (Attr)namedNodeMap.item(n);
                    Attr attr2 = document.createAttribute(attr.getName());
                    attr2.setValue(attr.getValue());
                    ((Element)node2).setAttributeNode(attr2);
                    ++n;
                }
                break;
            }
            case 3: {
                node2 = document.createTextNode(((CharacterData)node).getData());
                break;
            }
            case 4: {
                node2 = document.createCDATASection(((CharacterData)node).getData());
                break;
            }
            case 5: {
                node2 = document.createEntityReference(node.getNodeName());
                break;
            }
            case 7: {
                node2 = document.createProcessingInstruction(((ProcessingInstruction)node).getTarget(), ((ProcessingInstruction)node).getData());
                break;
            }
            case 8: {
                node2 = document.createComment(((CharacterData)node).getData());
                break;
            }
            case 11: {
                node2 = document.createDocumentFragment();
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                Assert.isTrue(false, Policy.bind("assert.notSupported"));
                break;
            }
            default: {
                Assert.isTrue(false, Policy.bind("assert.unknownNodeType"));
            }
        }
        return node2;
    }

    public static Element create(Document document, String string) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getDocumentElement() == null);
        Assert.isNotNull(string);
        Element element = document.createElement(string);
        ElementEditor.declareNS(element, null, DAV_NS);
        document.appendChild(element);
        return element;
    }

    public static void declareNS(Element element, String string, String string2) {
        Assert.isNotNull(element);
        Assert.isTrue(string2 != null || string == null && string2 == null);
        String string3 = XML_PREFIX + (string == null ? "" : ":" + string);
        String string4 = string2 == null ? "" : string2;
        element.setAttribute(string3, string4);
    }

    public static String decodeHref(String string) {
        return URLDecoder.decode(string);
    }

    public static String encodeHref(String string) {
        return URLEncoder.encode(string);
    }

    protected static void ensure(String string, boolean bl) throws MalformedElementException {
        if (!bl) {
            throw new MalformedElementException(string);
        }
    }

    protected static void ensure(boolean bl, String string) throws MalformedElementException {
        if (!bl) {
            throw new MalformedElementException(string);
        }
    }

    protected static Element ensureDAVElement(String string, Node node, String string2) throws MalformedElementException {
        Assert.isNotNull(string2);
        if (node == null || node.getNodeType() != 1) {
            throw new MalformedElementException(string);
        }
        Element element = (Element)node;
        if (!string2.equals(ElementEditor.getNSLocalName(element)) || !DAV_NS.equals(ElementEditor.getNSName(element))) {
            throw new MalformedElementException(string);
        }
        return element;
    }

    protected static void ensureDAVElement(Node node, String string, String string2) throws MalformedElementException {
        Assert.isNotNull(string);
        if (node == null || node.getNodeType() != 1) {
            throw new MalformedElementException(string2);
        }
        Element element = (Element)node;
        if (!string.equals(ElementEditor.getNSLocalName(element)) || !DAV_NS.equals(ElementEditor.getNSName(element))) {
            throw new MalformedElementException(string2);
        }
    }

    protected static void ensureNotNull(String string, Object object) throws MalformedElementException {
        if (object == null) {
            throw new MalformedElementException(string);
        }
    }

    protected static void ensureNull(String string, Object object) throws MalformedElementException {
        if (object != null) {
            throw new MalformedElementException(string);
        }
    }

    protected static Text ensureText(String string, Node node) throws MalformedElementException {
        if (node == null || node.getNodeType() != 3) {
            throw new MalformedElementException(string);
        }
        return (Text)node;
    }

    public static Element extractElement(Document document, Element element) throws MalformedElementException {
        Assert.isNotNull(document);
        Assert.isTrue(document.getDocumentElement() == null);
        Assert.isNotNull(element);
        return (Element)ElementEditor.extractNode(document, element);
    }

    public static Node extractNode(Node node, Node node2) throws MalformedElementException {
        Object object;
        Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        Node node3 = ElementEditor.cloneNode(document, node2);
        node.appendChild(node3);
        if (node2.getNodeType() == 1) {
            String string;
            object = ElementEditor.getNSPrefix((Element)node2);
            String string2 = ElementEditor.getNSName((Element)node2);
            if (!(string2 == (string = ElementEditor.resolve((String)object, (Element)node3)) || string2 != null && string2.equals(string))) {
                ElementEditor.declareNS((Element)node3, (String)object, string2);
            }
            NamedNodeMap namedNodeMap = node3.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                object = ElementEditor.getNSPrefix(attr.getName());
                if (!(object == null || ((String)object).equals(XML_PREFIX) || (string2 = ElementEditor.resolve((String)object, (Element)node2)) == (string = ElementEditor.resolve((String)object, (Element)node3)) || string2 != null && string2.equals(string))) {
                    ElementEditor.declareNS((Element)node3, (String)object, string2);
                }
                ++n;
            }
        }
        object = node2.getFirstChild();
        while (object != null) {
            ElementEditor.extractNode(node3, (Node)object);
            object = object.getNextSibling();
        }
        return node3;
    }

    private static Element getChild(Element element, String[] stringArray, boolean bl) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        Assert.isNotNull(stringArray);
        Node node = null;
        node = bl ? element.getFirstChild() : element.getLastChild();
        while (node != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (ElementEditor.isDAVElement(node, stringArray[n])) {
                    return (Element)node;
                }
                ++n;
            }
            node = bl ? node.getNextSibling() : node.getPreviousSibling();
        }
        return null;
    }

    public static Element getChild(Element element, String string, String[] stringArray, boolean bl) {
        Assert.isNotNull(element);
        Assert.isNotNull(string);
        Assert.isNotNull(stringArray);
        boolean bl2 = false;
        int n = 0;
        while (!bl2 && n < stringArray.length) {
            bl2 = stringArray[n].equals(string);
            ++n;
        }
        Assert.isTrue(bl2);
        Node node = null;
        if (bl) {
            n = 0;
            node = element.getFirstChild();
        } else {
            n = stringArray.length - 1;
            node = element.getLastChild();
        }
        while (node != null && !stringArray[n].equals(string)) {
            int n2 = n;
            while (!ElementEditor.isDAVElement(node, stringArray[n]) && !stringArray[n].equals(string)) {
                if (bl) {
                    ++n;
                    continue;
                }
                --n;
            }
            if (!stringArray[n].equals(string)) {
                if (bl) {
                    node = node.getNextSibling();
                    continue;
                }
                node = node.getPreviousSibling();
                continue;
            }
            if (ElementEditor.isDAVElement(node, stringArray[n])) continue;
            int n3 = n;
            bl2 = false;
            while (!bl2 && n3 >= 0 && n3 < stringArray.length) {
                bl2 = ElementEditor.isDAVElement(node, stringArray[n3]);
                if (bl) {
                    ++n3;
                    continue;
                }
                --n3;
            }
            if (bl2) continue;
            n = n2;
            node = bl ? node.getNextSibling() : node.getPreviousSibling();
        }
        return (Element)node;
    }

    public static Element getChildElement(Element element, boolean bl) {
        Assert.isNotNull(element);
        Node node = null;
        node = bl ? element.getFirstChild() : element.getLastChild();
        while (node != null && !ElementEditor.isElement(node)) {
            node = bl ? node.getNextSibling() : node.getPreviousSibling();
        }
        return (Element)node;
    }

    public static String getChildText(Element element, String string, boolean bl) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        Assert.isNotNull(string);
        Element element2 = bl ? ElementEditor.getFirstChild(element, string) : ElementEditor.getLastChild(element, string);
        if (element2 != null) {
            return ElementEditor.getText(element2, bl);
        }
        return null;
    }

    public static Element getDAVChild(Element element) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        Node node = element.getFirstChild();
        while (node != null && !ElementEditor.isDAVElement(node)) {
            node = node.getNextSibling();
        }
        return (Element)node;
    }

    public Element getElement() {
        return this.root;
    }

    public static Element getFirstChild(Element element, String[] stringArray) {
        return ElementEditor.getChild(element, stringArray, true);
    }

    public static Element getFirstChild(Element element, String string) {
        Assert.isNotNull(string);
        return ElementEditor.getChild(element, new String[]{string}, true);
    }

    public static String getFirstText(Element element) {
        Assert.isNotNull(element);
        Node node = element.getFirstChild();
        while (node != null && !ElementEditor.isText(node)) {
            node = node.getNextSibling();
        }
        if (node == null) {
            return "";
        }
        return ((Text)node).getData();
    }

    public static Element getLastChild(Element element, String string) {
        Assert.isNotNull(string);
        return ElementEditor.getChild(element, new String[]{string}, false);
    }

    public static Namespaces getNamespaces(Element element) {
        Assert.isNotNull(element);
        Node node = element.getParentNode();
        while (node != null && !ElementEditor.isElement(node)) {
            node = node.getParentNode();
        }
        Namespaces namespaces = null;
        if (node != null) {
            namespaces = ElementEditor.getNamespaces((Element)node);
        }
        return ElementEditor.getNamespaces(element, namespaces, false);
    }

    protected static Namespaces getNamespaces(Element element, Namespaces namespaces, boolean bl) {
        Namespaces namespaces2 = null;
        namespaces2 = namespaces == null ? new Namespaces() : new Namespaces(namespaces);
        Vector<Attr> vector = new Vector<Attr>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            String string = attr.getName();
            if (string.startsWith(XML_PREFIX)) {
                String string2;
                String string3 = attr.getValue();
                if (string.length() == XML_PREFIX.length()) {
                    if (string3.equals("")) {
                        namespaces2.setDefaultNSName(null);
                    } else {
                        namespaces2.setDefaultNSName(string3);
                    }
                } else if (string.charAt(XML_PREFIX.length()) == ':' && (string2 = string.substring(XML_PREFIX.length() + 1)).length() > 0 && string3.length() > 0) {
                    boolean bl2;
                    namespaces2.putNSName(string2, string3);
                    boolean bl3 = bl2 = namespaces2.getNSPrefix(string3) != null;
                    if (!bl2) {
                        namespaces2.putNSPrefix(string3, string2);
                    }
                    if (bl && (bl2 || string3.equals(namespaces2.getDefaultNSName()))) {
                        vector.addElement(attr);
                    }
                }
            }
            ++n;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            element.removeAttributeNode((Attr)enumeration.nextElement());
        }
        return namespaces2;
    }

    public static Element getNextSibling(Element element) {
        Assert.isNotNull(element);
        Node node = element;
        while ((node = node.getNextSibling()) != null && !ElementEditor.isElement(node)) {
        }
        return node;
    }

    public static Element getNextSibling(Element element, String[] stringArray) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        Assert.isNotNull(stringArray);
        Node node = element.getNextSibling();
        while (node != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (ElementEditor.isDAVElement(node, stringArray[n])) {
                    return (Element)node;
                }
                ++n;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static Element getNextSibling(Element element, String string) {
        return ElementEditor.getNextSibling(element, new String[]{string});
    }

    public static String getNSLocalName(String string) {
        Assert.isNotNull(string);
        int n = string.lastIndexOf(58);
        if (n == -1) {
            return string;
        }
        if (n == string.length() - 1) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static String getNSLocalName(Element element) {
        Assert.isNotNull(element);
        return ElementEditor.getNSLocalName(element.getTagName());
    }

    public static String getNSName(Element element) throws MalformedElementException {
        Assert.isNotNull(element);
        String string = ElementEditor.getNSPrefix(element);
        String string2 = ElementEditor.resolve(string, element);
        if (string != null && string2 == null) {
            throw new MalformedElementException(Policy.bind("exception.namespacePrefixNotResolved", string));
        }
        return string2;
    }

    public static String getNSPrefix(String string) {
        Assert.isNotNull(string);
        int n = string.lastIndexOf(58);
        if (n <= 0) {
            return null;
        }
        return string.substring(0, n);
    }

    public static String getNSPrefix(Element element) {
        Assert.isNotNull(element);
        return ElementEditor.getNSPrefix(element.getTagName());
    }

    public static QualifiedName getQualifiedName(Element element) throws MalformedElementException {
        Assert.isNotNull(element);
        String string = ElementEditor.getNSName(element);
        String string2 = ElementEditor.getNSLocalName(element);
        if (string2 == null) {
            throw new MalformedElementException(Policy.bind("exception.noLocalNameForElmt"));
        }
        return new QualifiedNameImpl(string, string2);
    }

    public static Element getSibling(Element element, String string, boolean bl) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        Assert.isNotNull(string);
        Node node = element;
        while ((node = bl ? node.getNextSibling() : node.getPreviousSibling()) != null && !ElementEditor.isDAVElement(node, string)) {
        }
        return node;
    }

    public static String getText(Element element, boolean bl) {
        Assert.isNotNull(element);
        Node node = null;
        node = bl ? element.getFirstChild() : element.getLastChild();
        while (node != null && !ElementEditor.isText(node)) {
            node = bl ? node.getNextSibling() : node.getPreviousSibling();
        }
        if (node != null) {
            return ((Text)node).getData();
        }
        return "";
    }

    public static Element getTwin(Element element, boolean bl) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        String string = ElementEditor.getNSLocalName(element);
        return ElementEditor.getSibling(element, string, bl);
    }

    public static boolean hasChild(Element element, QualifiedName qualifiedName) throws MalformedElementException {
        Node node = element.getFirstChild();
        while (node != null) {
            QualifiedName qualifiedName2;
            if (node instanceof Element && (qualifiedName2 = ElementEditor.getQualifiedName((Element)node)).equals(qualifiedName)) {
                return true;
            }
            node = node.getNextSibling();
        }
        return false;
    }

    public static Element insertBefore(Element element, String string) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        Assert.isNotNull(string);
        String string2 = ElementEditor.getNSPrefix(element);
        String string3 = string2 == null ? string : String.valueOf(string2) + ":" + string;
        Element element2 = element.getOwnerDocument().createElement(string3);
        element.getParentNode().insertBefore(element2, element);
        return element2;
    }

    public static Element insertBefore(Element element, String string, String string2) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        Assert.isNotNull(string);
        Assert.isNotNull(string2);
        Element element2 = ElementEditor.insertBefore(element, string);
        element2.appendChild(element2.getOwnerDocument().createTextNode(string2));
        return element2;
    }

    public static boolean isDAVElement(Node node) {
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        try {
            return DAV_NS.equals(ElementEditor.getNSName((Element)node));
        }
        catch (MalformedElementException malformedElementException) {
            return false;
        }
    }

    public static boolean isDAVElement(Node node, String string) {
        Assert.isNotNull(string);
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        try {
            Element element = (Element)node;
            return string.equals(ElementEditor.getNSLocalName(element)) && DAV_NS.equals(ElementEditor.getNSName(element));
        }
        catch (MalformedElementException malformedElementException) {
            return false;
        }
    }

    public static boolean isElement(Node node) {
        return node != null && node.getNodeType() == 1;
    }

    public static boolean isText(Node node) {
        return node != null && node.getNodeType() == 3;
    }

    public static void makeNSStandalone(Element element) {
        Assert.isTrue(false, Policy.bind("assert.notImplemented"));
    }

    public static Element reduceNS(Element element) throws MalformedElementException {
        return (Element)ElementEditor.reduceNS(element, null);
    }

    public static Node reduceNS(Node node, Namespaces namespaces) throws MalformedElementException {
        Node node2;
        Namespaces namespaces2 = namespaces;
        if (node.getNodeType() == 1) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            node2 = (Element)node;
            namespaces2 = ElementEditor.getNamespaces((Element)node2, namespaces, false);
            String string = ElementEditor.getNSPrefix((Element)node2);
            String string2 = ElementEditor.getNSLocalName((Element)node2);
            if (string != null) {
                object6 = namespaces2.getNSName(string);
                ElementEditor.ensureNotNull(Policy.bind("ensure.missingNamespaceForPrefix", string), object6);
                object5 = null;
                object5 = ((String)object6).equals(namespaces2.getDefaultNSName()) ? string2 : String.valueOf(namespaces2.getNSPrefix((String)object6)) + ":" + string2;
                if (!((String)object5).equals(node2.getTagName())) {
                    object4 = node2.getOwnerDocument();
                    Element element = object4.createElement((String)object5);
                    object3 = node2.getAttributes();
                    int n = 0;
                    while (n < object3.getLength()) {
                        object2 = (Attr)object3.item(n);
                        element.setAttribute(object2.getName(), object2.getValue());
                        ++n;
                    }
                    object = node2.getFirstChild();
                    while (object != null) {
                        node2.removeChild((Node)object);
                        element.appendChild((Node)object);
                        object = node2.getFirstChild();
                    }
                    node2.getParentNode().replaceChild(element, node2);
                    node2 = element;
                }
            }
            object6 = new Vector();
            object5 = new Vector();
            object4 = node2.getAttributes();
            int n = 0;
            while (n < object4.getLength()) {
                object3 = (Attr)object4.item(n);
                object = object3.getName();
                object2 = object3.getValue();
                Object object7 = object;
                string = ElementEditor.getNSPrefix((String)object);
                string2 = ElementEditor.getNSLocalName((String)object);
                if (string != null && !string.equals(XML_PREFIX)) {
                    String string3 = namespaces2.getNSName(string);
                    ElementEditor.ensureNotNull(Policy.bind("ensure.missingNamespaceForPrefix", string), string3);
                    String string4 = namespaces2.getNSPrefix(string3);
                    if (!string4.equals(string)) {
                        object7 = String.valueOf(string4) + ":" + string2;
                    }
                }
                boolean bl = true;
                if (namespaces != null) {
                    if (string == null && XML_PREFIX.equals(string2) && ((String)object2).equals(namespaces.getDefaultNSName())) {
                        bl = false;
                    }
                    if (string != null && XML_PREFIX.equals(string) && namespaces.getNSPrefix((String)object2) != null) {
                        bl = false;
                    }
                }
                ((Vector)object6).addElement(object3);
                if (bl) {
                    ((Vector)object5).addElement(new String[]{object7, object2});
                }
                ++n;
            }
            Enumeration enumeration = ((Vector)object6).elements();
            while (enumeration.hasMoreElements()) {
                node2.removeAttributeNode((Attr)enumeration.nextElement());
            }
            object3 = ((Vector)object5).elements();
            while (object3.hasMoreElements()) {
                object = (String[])object3.nextElement();
                node2.setAttribute(object[0], object[1]);
            }
            node = node2;
        }
        node2 = node.getFirstChild();
        while (node2 != null) {
            node2 = ElementEditor.reduceNS(node2, namespaces2);
            node2 = node2.getNextSibling();
        }
        return node;
    }

    public static String resolve(String string, Element element) {
        Assert.isNotNull(element);
        if (XML_NS_PREFIX.equals(string)) {
            return XML_NS_NAME;
        }
        Node node = element;
        do {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                Attr attr = (Attr)namedNodeMap.item(n2);
                String string2 = attr.getName();
                if (string2.startsWith(XML_PREFIX)) {
                    if (string2.length() == XML_PREFIX.length()) {
                        if (string == null) {
                            String string3 = attr.getValue();
                            if (string3.equals("")) {
                                return null;
                            }
                            return string3;
                        }
                    } else if (string != null && string2.equals("xmlns:" + string)) {
                        return attr.getValue();
                    }
                }
                ++n2;
            }
            while ((node = node.getParentNode()) != null && node.getNodeType() != 1) {
            }
        } while (node != null);
        return null;
    }

    public static Element setChild(Element element, String string, String[] stringArray, boolean bl) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        Assert.isNotNull(string);
        Assert.isNotNull(stringArray);
        String string2 = ElementEditor.getNSPrefix(element);
        String string3 = string2 == null ? string : String.valueOf(string2) + ":" + string;
        Element element2 = element.getOwnerDocument().createElement(string3);
        ElementEditor.setChild(element, element2, stringArray, bl);
        return element2;
    }

    public static Element setChild(Element element, String string, String string2, String[] stringArray, boolean bl) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        Assert.isNotNull(string);
        Assert.isNotNull(string2);
        Assert.isNotNull(stringArray);
        Element element2 = ElementEditor.setChild(element, string, stringArray, bl);
        element2.appendChild(element.getOwnerDocument().createTextNode(string2));
        return element2;
    }

    public static void setChild(Element element, Element element2, String[] stringArray, boolean bl) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        Assert.isNotNull(element2);
        Assert.isTrue(DAV_NS.equals(ElementEditor.resolve(ElementEditor.getNSPrefix(element2), element)));
        Assert.isNotNull(stringArray);
        boolean bl2 = false;
        String string = ElementEditor.getNSLocalName(element2);
        int n = 0;
        while (!bl2 && n < stringArray.length) {
            bl2 = stringArray[n].equals(string);
            ++n;
        }
        Assert.isTrue(bl2);
        Element element3 = ElementEditor.getChild(element, string, stringArray, bl);
        if (ElementEditor.isDAVElement(element3, string)) {
            element.replaceChild(element2, element3);
        } else if (bl) {
            if (element3 == null) {
                element.appendChild(element2);
            } else {
                element.insertBefore(element2, element3);
            }
        } else {
            Node node = null;
            node = element3 == null ? element.getFirstChild() : element3.getNextSibling();
            if (node == null) {
                element.appendChild(element2);
            } else {
                element.insertBefore(element2, node);
            }
        }
    }
}

