/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.QualifiedName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HrefSet
extends ElementEditor {
    public HrefSet(Element element, QualifiedName qualifiedName) throws MalformedElementException {
        super(element, qualifiedName.getLocalName());
        HrefSet.ensure("DAV:".equals(qualifiedName.getQualifier()), Policy.bind("ensure.mustHaveDAVQualifier"));
    }

    public void addHref(String string) {
        String string2 = HrefSet.encodeHref(string);
        if (this.isDuplicate(string2)) {
            return;
        }
        HrefSet.appendChild(this.root, "href", string2);
    }

    public static HrefSet create(Document document, QualifiedName qualifiedName) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getOwnerDocument() == null);
        Assert.isNotNull(qualifiedName);
        Assert.isTrue("DAV:".equals(qualifiedName.getQualifier()));
        Element element = HrefSet.create(document, qualifiedName.getLocalName());
        try {
            return new HrefSet(element, qualifiedName);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public Enumeration getHrefs() {
        Element element = HrefSet.getFirstChild(this.root, "href");
        Enumeration enumeration = new Enumeration(element){
            Element currentHref;
            {
                this.currentHref = element;
            }

            public boolean hasMoreElements() {
                return this.currentHref != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String string = HrefSet.getFirstText(this.currentHref);
                this.currentHref = HrefSet.getNextSibling(this.currentHref, "href");
                return HrefSet.decodeHref(string);
            }
        };
        return enumeration;
    }

    public void insertHrefAfter(String string, String string2) {
        String string3 = HrefSet.encodeHref(string);
        String string4 = HrefSet.encodeHref(string2);
        if (this.isDuplicate(string4)) {
            return;
        }
        Element element = HrefSet.getFirstChild(this.root, "href");
        while (element != null) {
            if (string3.equals(HrefSet.getFirstText(element))) {
                Element element2 = HrefSet.getNextSibling(element, "href");
                if (element2 == null) {
                    HrefSet.appendChild(this.root, "href", string4);
                } else {
                    HrefSet.insertBefore(element2, "href", string4);
                }
                return;
            }
            element = HrefSet.getNextSibling(element, "href");
        }
        Assert.isTrue(false, Policy.bind("assert.noHrefRef"));
    }

    public void insertHrefBefore(String string, String string2) {
        String string3 = HrefSet.encodeHref(string2);
        String string4 = HrefSet.encodeHref(string);
        if (this.isDuplicate(string4)) {
            return;
        }
        Element element = HrefSet.getFirstChild(this.root, "href");
        while (element != null) {
            if (string3.equals(HrefSet.getFirstText(element))) {
                HrefSet.insertBefore(element, "href", string4);
                return;
            }
            element = HrefSet.getNextSibling(element, "href");
        }
        Assert.isTrue(false, Policy.bind("assert.noHrefRef"));
    }

    protected boolean isDuplicate(String string) {
        Element element = HrefSet.getFirstChild(this.root, "href");
        while (element != null) {
            if (string.equals(HrefSet.getFirstText(element))) {
                return true;
            }
            element = HrefSet.getNextSibling(element, "href");
        }
        return false;
    }

    public void removeHref(String string) {
        String string2 = HrefSet.encodeHref(string);
        Element element = HrefSet.getFirstChild(this.root, "href");
        while (element != null) {
            if (string2.equals(HrefSet.getFirstText(element))) {
                this.root.removeChild(element);
                return;
            }
            element = HrefSet.getNextSibling(element, "href");
        }
    }
}

