/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.ActiveLock;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Property;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LockDiscovery
extends Property {
    protected static final String[] childNames = new String[]{"activelock"};

    public LockDiscovery(Element element) throws MalformedElementException {
        super(element, "lockdiscovery");
    }

    public ActiveLock addActiveLock() {
        Element element = LockDiscovery.addChild(this.root, "activelock", childNames, false);
        Element element2 = LockDiscovery.appendChild(element, "locktype");
        LockDiscovery.appendChild(element2, "write");
        ActiveLock activeLock = null;
        try {
            activeLock = new ActiveLock(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return activeLock;
    }

    public Enumeration getActiveLocks() throws MalformedElementException {
        Element element = LockDiscovery.getFirstChild(this.root, "activelock");
        Enumeration enumeration = new Enumeration(element){
            Node currentActiveLock;
            {
                this.currentActiveLock = node;
            }

            public boolean hasMoreElements() {
                return this.currentActiveLock != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                ActiveLock activeLock = null;
                try {
                    activeLock = new ActiveLock((Element)this.currentActiveLock);
                }
                catch (MalformedElementException malformedElementException) {
                    Assert.isTrue(false, Policy.bind("assert.internalError"));
                }
                this.currentActiveLock = LockDiscovery.getTwin((Element)this.currentActiveLock, true);
                return activeLock;
            }
        };
        return enumeration;
    }
}

