/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.w3c.dom.Element;

public class LockEntry
extends ElementEditor {
    protected static final String[] childNames = new String[]{"lockscope", "locktype"};

    public LockEntry(Element element) throws MalformedElementException {
        super(element, "lockentry");
    }

    public boolean isShared() throws MalformedElementException {
        Element element = LockEntry.getFirstChild(this.root, "lockscope");
        LockEntry.ensureNotNull(Policy.bind("ensure.missingLockscopeElmt"), element);
        String[] stringArray = new String[]{"shared", "exclusive"};
        Element element2 = LockEntry.getFirstChild(element, stringArray);
        LockEntry.ensureNotNull(Policy.bind("ensure.missingSharedOrExclusiveElmt"), element2);
        boolean bl = LockEntry.isDAVElement(element2, "shared");
        LockEntry.ensure(LockEntry.getNextSibling(element2, stringArray) == null, Policy.bind("ensure.conflictingSharedOrExclusiveElmt"));
        return bl;
    }

    public void setIsShared(boolean bl) {
        Element element = LockEntry.setChild(this.root, "lockscope", childNames, true);
        if (bl) {
            LockEntry.appendChild(element, "shared");
        } else {
            LockEntry.appendChild(element, "exclusive");
        }
    }
}

