/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Owner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LockInfo
extends ElementEditor {
    public static final String[] childNames = new String[]{"lockscope", "locktype", "owner"};

    public LockInfo(Element element) throws MalformedElementException {
        super(element, "lockinfo");
    }

    public static LockInfo create(Document document) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getOwnerDocument() == null);
        Element element = LockInfo.create(document, "lockinfo");
        Element element2 = LockInfo.appendChild(element, "locktype");
        LockInfo.appendChild(element2, "write");
        LockInfo lockInfo = null;
        try {
            lockInfo = new LockInfo(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return lockInfo;
    }

    public Owner getOwner() throws MalformedElementException {
        Element element = LockInfo.getLastChild(this.root, "owner");
        if (element == null) {
            return null;
        }
        return new Owner(element);
    }

    public boolean isShared() throws MalformedElementException {
        Element element = LockInfo.getFirstChild(this.root, "lockscope");
        LockInfo.ensureNotNull(Policy.bind("ensure.missingLockscopeElmt"), element);
        String[] stringArray = new String[]{"shared", "exclusive"};
        Element element2 = LockInfo.getFirstChild(element, stringArray);
        LockInfo.ensureNotNull(Policy.bind("ensure.missingSharedOrExclusiveElmt"), element2);
        boolean bl = LockInfo.isDAVElement(element2, "shared");
        LockInfo.ensure(LockInfo.getNextSibling(element2, stringArray) == null, Policy.bind("ensure.conflictingSharedOrExclusiveElmt"));
        return bl;
    }

    public void setIsShared(boolean bl) {
        Element element = LockInfo.setChild(this.root, "lockscope", childNames, true);
        if (bl) {
            LockInfo.appendChild(element, "shared");
        } else {
            LockInfo.appendChild(element, "exclusive");
        }
    }

    public Owner setOwner() {
        Element element = LockInfo.setChild(this.root, "owner", childNames, false);
        Owner owner = null;
        try {
            owner = new Owner(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return owner;
    }
}

