/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.QualifiedName;
import org.eclipse.webdav.dom.QualifiedNameImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Prop
extends ElementEditor {
    public Prop(Element element) throws MalformedElementException {
        super(element, "prop");
    }

    public void addProperty(Element element) throws MalformedElementException {
        Assert.isNotNull(element);
        Prop.extractNode(this.root, element);
    }

    public void addPropertyName(QualifiedName qualifiedName) {
        Assert.isNotNull(qualifiedName);
        String string = qualifiedName.getQualifier();
        Assert.isTrue(!"".equals(string));
        String string2 = qualifiedName.getLocalName();
        Assert.isNotNull(string2);
        Assert.isTrue(!string2.equals(""));
        Document document = this.root.getOwnerDocument();
        Element element = document.createElement(string2);
        Prop.declareNS(element, null, string);
        this.root.appendChild(element);
    }

    public Enumeration getProperties() throws MalformedElementException {
        Element element;
        Element element2 = element = Prop.getChildElement(this.root, true);
        Enumeration enumeration = new Enumeration(element2){
            Node currentElement;
            {
                this.currentElement = node;
            }

            public boolean hasMoreElements() {
                return this.currentElement != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                Node node = this.currentElement;
                this.currentElement = Prop.getNextSibling((Element)this.currentElement);
                return node;
            }
        };
        return enumeration;
    }

    public Enumeration getPropertyNames() throws MalformedElementException {
        Element element;
        Element element2 = element = Prop.getChildElement(this.root, true);
        Enumeration enumeration = new Enumeration(element2){
            Node currentElement;
            {
                this.currentElement = node;
            }

            public boolean hasMoreElements() {
                return this.currentElement != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String string = null;
                try {
                    string = Prop.getNSName((Element)this.currentElement);
                }
                catch (MalformedElementException malformedElementException) {
                    Assert.isTrue(false, Policy.bind("assert.internalError"));
                }
                String string2 = Prop.getNSLocalName((Element)this.currentElement);
                QualifiedNameImpl qualifiedNameImpl = new QualifiedNameImpl(string, string2);
                this.currentElement = Prop.getNextSibling((Element)this.currentElement);
                return qualifiedNameImpl;
            }
        };
        return enumeration;
    }
}

