/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Prop;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PropFind
extends ElementEditor {
    protected static final String[] childNames = new String[]{"allprop", "propname", "prop"};

    public PropFind(Element element) throws MalformedElementException {
        super(element, "propfind");
    }

    public static PropFind create(Document document) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getDocumentElement() == null);
        Element element = PropFind.create(document, "propfind");
        try {
            return new PropFind(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public Prop getProp() throws MalformedElementException {
        Element element = PropFind.getFirstChild(this.root, "prop");
        PropFind.ensureNotNull(Policy.bind("ensure.missingPropElmt"), element);
        return new Prop(element);
    }

    public boolean isAllProp() throws MalformedElementException {
        Element element = PropFind.getFirstChild(this.root, childNames);
        PropFind.ensureNotNull(Policy.bind("ensure.missingAllpropOrPropnameOrPropElmt"), element);
        boolean bl = PropFind.isDAVElement(element, "allprop");
        element = PropFind.getNextSibling(element, childNames);
        PropFind.ensureNull(Policy.bind("ensure.conflictingAllpropOrPropnameOrPropElmt"), element);
        return bl;
    }

    public boolean isProp() throws MalformedElementException {
        Element element = PropFind.getFirstChild(this.root, childNames);
        PropFind.ensureNotNull(Policy.bind("ensure.missingAllpropOrPropnameOrPropElmt"), element);
        boolean bl = PropFind.isDAVElement(element, "prop");
        element = PropFind.getNextSibling(element, childNames);
        PropFind.ensureNull(Policy.bind("ensure.conflictingAllpropOrPropnameOrPropElmt"), element);
        return bl;
    }

    public boolean isPropName() throws MalformedElementException {
        Element element = PropFind.getFirstChild(this.root, childNames);
        PropFind.ensureNotNull(Policy.bind("ensure.missingAllpropOrPropnameOrPropElmt"), element);
        boolean bl = PropFind.isDAVElement(element, "propname");
        element = PropFind.getNextSibling(element, childNames);
        PropFind.ensureNull(Policy.bind("ensure.conflictingAllpropOrPropnameOrPropElmt"), element);
        return bl;
    }

    public void setIsAllProp(boolean bl) {
        Element element = PropFind.getFirstChild(this.root, childNames);
        boolean bl2 = PropFind.isDAVElement(element, "allprop");
        if (bl) {
            if (!bl2) {
                if (element != null) {
                    this.root.removeChild(element);
                }
                PropFind.appendChild(this.root, "allprop");
            }
        } else if (bl2) {
            this.root.removeChild(element);
        }
    }

    public void setIsPropName(boolean bl) {
        Element element = PropFind.getFirstChild(this.root, childNames);
        boolean bl2 = PropFind.isDAVElement(element, "propname");
        if (bl) {
            if (!bl2) {
                if (element != null) {
                    this.root.removeChild(element);
                }
                PropFind.appendChild(this.root, "propname");
            }
        } else if (bl2) {
            this.root.removeChild(element);
        }
    }

    public Prop setProp() {
        Assert.isTrue(PropFind.getFirstChild(this.root, new String[]{"allprop", "propname"}) == null);
        Element element = PropFind.setChild(this.root, "prop", new String[]{"prop"}, true);
        try {
            return new Prop(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }
}

