/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Prop;
import org.eclipse.webdav.dom.Status;
import org.w3c.dom.Element;

public class PropStat
extends ElementEditor {
    protected static final String[] childNames = new String[]{"prop", "status", "responsedescription"};

    public PropStat(Element element) throws MalformedElementException {
        super(element, "propstat");
    }

    public Prop getProp() throws MalformedElementException {
        Element element = PropStat.getFirstChild(this.root, "prop");
        PropStat.ensureNotNull(Policy.bind("ensure.missingPropElmt"), element);
        return new Prop(element);
    }

    public String getResponseDescription() throws MalformedElementException {
        return PropStat.getChildText(this.root, "responsedescription", false);
    }

    public String getStatus() throws MalformedElementException {
        String string = PropStat.getChildText(this.root, "status", false);
        PropStat.ensureNotNull(Policy.bind("ensure.missingStatusElmt"), string);
        return string;
    }

    public int getStatusCode() throws MalformedElementException {
        return new Status(this.getStatus()).getStatusCode();
    }

    public Prop setProp() {
        Element element = PropStat.setChild(this.root, "prop", childNames, true);
        try {
            return new Prop(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public void setResponseDescription(String string) {
        if (string == null) {
            Element element = PropStat.getLastChild(this.root, "responsedescription");
            if (element != null) {
                this.root.removeChild(element);
            }
        } else {
            PropStat.setChild(this.root, "responsedescription", string, childNames, false);
        }
    }

    public void setStatus(String string) {
        Assert.isNotNull(string);
        PropStat.setChild(this.root, "status", string, childNames, true);
    }
}

