/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PropertyBehavior
extends ElementEditor {
    protected static final String[] childNames = new String[]{"omit", "keepalive"};
    public static String[] fgNamesOmit = new String[]{"omit"};
    public static String[] fgNamesKeepAlive = new String[]{"keepalive"};

    public PropertyBehavior(Element element) throws MalformedElementException {
        super(element, "propertybehavior");
    }

    public void addProperty(String string) {
        Assert.isNotNull(string);
        Assert.isTrue(PropertyBehavior.getFirstChild(this.root, "omit") == null);
        Element element = PropertyBehavior.getFirstChild(this.root, "keepalive");
        if (element == null) {
            element = PropertyBehavior.addChild(this.root, "keepalive", fgNamesKeepAlive, true);
        } else {
            Assert.isTrue(!"*".equals(PropertyBehavior.getFirstText(element)));
        }
        PropertyBehavior.addChild(element, "href", PropertyBehavior.encodeHref(string), new String[]{"href"}, false);
    }

    public static PropertyBehavior create(Document document) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getOwnerDocument() == null);
        Element element = PropertyBehavior.create(document, "propertybehavior");
        PropertyBehavior propertyBehavior = null;
        try {
            propertyBehavior = new PropertyBehavior(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return propertyBehavior;
    }

    public Enumeration getProperties() throws MalformedElementException {
        Element element = PropertyBehavior.getFirstChild(this.root, "keepalive");
        PropertyBehavior.ensureNotNull(Policy.bind("ensure.missingKeealiveElmt"), element);
        PropertyBehavior.ensure(!"*".equals(PropertyBehavior.getFirstText(element)), Policy.bind("ensure.wrongForm"));
        Element element2 = PropertyBehavior.getFirstChild(element, "href");
        PropertyBehavior.ensureNotNull(Policy.bind("ensure.missingHrefElmt"), element2);
        Enumeration enumeration = new Enumeration(element2){
            Element currentHref;
            {
                this.currentHref = element;
            }

            public boolean hasMoreElements() {
                return this.currentHref != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String string = PropertyBehavior.getFirstText(this.currentHref);
                this.currentHref = PropertyBehavior.getTwin(this.currentHref, true);
                return PropertyBehavior.decodeHref(string);
            }
        };
        return enumeration;
    }

    public boolean isKeepAllAlive() throws MalformedElementException {
        Element element = PropertyBehavior.getFirstChild(this.root, childNames);
        PropertyBehavior.ensureNotNull(Policy.bind("ensure.expectingOmitOrKeepaliveElmt"), element);
        boolean bl = false;
        if (PropertyBehavior.isDAVElement(element, "keepalive")) {
            bl = "*".equals(PropertyBehavior.getFirstText(element));
            PropertyBehavior.ensureNull(Policy.bind("ensure.conflictingHrefElmt"), PropertyBehavior.getFirstChild(element, "href"));
        }
        element = PropertyBehavior.getNextSibling(element, childNames);
        PropertyBehavior.ensureNull(Policy.bind("ensure.conflictingOmitOrKeepaliveElmt"), element);
        return bl;
    }

    public boolean isOmit() throws MalformedElementException {
        Element element = PropertyBehavior.getFirstChild(this.root, childNames);
        PropertyBehavior.ensureNotNull(Policy.bind("ensure.expectingOmitOrKeepaliveElmt"), element);
        boolean bl = PropertyBehavior.isDAVElement(element, "omit");
        element = PropertyBehavior.getNextSibling(element, childNames);
        PropertyBehavior.ensureNull(Policy.bind("ensure.conflictingOmitOrKeepaliveElmt"), element);
        return bl;
    }

    public void setIsKeepAllAlive(boolean bl) {
        Element element = PropertyBehavior.getFirstChild(this.root, childNames);
        boolean bl2 = false;
        if (PropertyBehavior.isDAVElement(element, "keepalive")) {
            bl2 = "*".equals(PropertyBehavior.getFirstText(element));
        }
        if (bl) {
            if (!bl2) {
                if (element != null) {
                    this.root.removeChild(element);
                }
                PropertyBehavior.appendChild(this.root, "keepalive", "*");
            }
        } else if (bl2) {
            this.root.removeChild(element);
        }
    }

    public void setIsOmit(boolean bl) {
        Element element = PropertyBehavior.getFirstChild(this.root, childNames);
        boolean bl2 = PropertyBehavior.isDAVElement(element, "omit");
        if (bl) {
            if (!bl2) {
                if (element != null) {
                    this.root.removeChild(element);
                }
                PropertyBehavior.appendChild(this.root, "omit");
            }
        } else if (bl2) {
            this.root.removeChild(element);
        }
    }
}

