/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Prop;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertyUpdate
extends ElementEditor {
    public PropertyUpdate(Element element) throws MalformedElementException {
        super(element, "propertyupdate");
    }

    public Prop addRemove() {
        Element element = PropertyUpdate.appendChild(this.root, "remove");
        Element element2 = PropertyUpdate.appendChild(element, "prop");
        Prop prop = null;
        try {
            prop = new Prop(element2);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return prop;
    }

    public Prop addSet() {
        Element element = PropertyUpdate.appendChild(this.root, "set");
        Element element2 = PropertyUpdate.appendChild(element, "prop");
        try {
            return new Prop(element2);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public static PropertyUpdate create(Document document) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getDocumentElement() == null);
        Element element = PropertyUpdate.create(document, "propertyupdate");
        PropertyUpdate propertyUpdate = null;
        try {
            propertyUpdate = new PropertyUpdate(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return propertyUpdate;
    }

    public Enumeration getSetsAndRemoves() throws MalformedElementException {
        Element element;
        Element element2 = PropertyUpdate.getFirstChild(this.root, new String[]{"remove", "set"});
        PropertyUpdate.ensureNotNull(Policy.bind("ensure.missingRemoveOrSetElmt"), element2);
        Element element3 = null;
        while (element2 != null && element3 == null) {
            element = PropertyUpdate.getFirstChild(element2, "prop");
            PropertyUpdate.ensureNotNull(Policy.bind("ensure.missingPropElmt"), element);
            element3 = PropertyUpdate.getChildElement(element, true);
            if (element3 != null) continue;
            element2 = PropertyUpdate.getNextSibling(element2, new String[]{"remove", "set"});
        }
        element = element2;
        Element element4 = element3;
        Enumeration enumeration = new Enumeration(element, element4){
            Node currentSetOrRemove;
            Node currentProperty;
            {
                this.currentSetOrRemove = node;
                this.currentProperty = node2;
            }

            public boolean hasMoreElements() {
                return this.currentProperty != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                Directive directive = null;
                try {
                    directive = new Directive((Element)this.currentProperty);
                }
                catch (MalformedElementException malformedElementException) {
                    Assert.isTrue(false, Policy.bind("assert.internalError"));
                }
                this.currentProperty = PropertyUpdate.getNextSibling((Element)this.currentProperty);
                while (this.currentSetOrRemove != null && this.currentProperty == null) {
                    Element element;
                    this.currentSetOrRemove = PropertyUpdate.getNextSibling((Element)this.currentSetOrRemove, new String[]{"remove", "set"});
                    if (this.currentSetOrRemove == null || (element = PropertyUpdate.getFirstChild((Element)this.currentSetOrRemove, "prop")) == null) continue;
                    this.currentProperty = PropertyUpdate.getChildElement(element, true);
                }
                return directive;
            }
        };
        return enumeration;
    }

    public class Directive
    extends ElementEditor {
        public Directive(Element element) throws MalformedElementException {
            super(element);
            Node node = element.getParentNode();
            Directive.ensureDAVElement(node, "prop", Policy.bind("ensure.expectingPropElmt"));
            Node node2 = node.getParentNode();
            Directive.ensure(Directive.isDAVElement(node2, "remove") || Directive.isDAVElement(node2, "set"), Policy.bind("ensure.expectingRemoveOrSetElmt"));
        }

        public Element getProperty() throws MalformedElementException {
            return this.root;
        }

        public boolean isRemove() throws MalformedElementException {
            Node node = this.root.getParentNode();
            Directive.ensureDAVElement(node, "prop", Policy.bind("ensure.expectingPropElmt"));
            Node node2 = node.getParentNode();
            return Directive.isDAVElement(node2, "remove");
        }

        public boolean isSet() throws MalformedElementException {
            Node node = this.root.getParentNode();
            Directive.ensureDAVElement(node, "prop", Policy.bind("ensure.expectingPropElmt"));
            Node node2 = node.getParentNode();
            return Directive.isDAVElement(node2, "set");
        }
    }
}

