/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.PropStat;
import org.eclipse.webdav.dom.QualifiedName;
import org.eclipse.webdav.dom.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResponseBody
extends ElementEditor {
    protected static final String[] childNames = new String[]{"href", "href", "status", "propstat", "responsedescription"};
    public static String[] fgNamesStatus = new String[]{"href", "href", "status", "responsedescription"};
    public static String[] fgNamesPropStat = new String[]{"href", "propstat", "responsedescription"};

    public ResponseBody(Element element) throws MalformedElementException {
        super(element, "response");
    }

    public PropStat accumulatePropStat(QualifiedName qualifiedName, String string, String string2) {
        Assert.isNotNull(qualifiedName);
        Assert.isNotNull(string);
        Element element = ResponseBody.getFirstChild(this.root, new String[]{"href", "status"});
        Assert.isTrue(element == null || ResponseBody.isDAVElement(element, "href") && ResponseBody.getNextSibling(element, new String[]{"href", "status"}) == null);
        String string3 = qualifiedName.getQualifier();
        Assert.isTrue(!"".equals(string3));
        String string4 = qualifiedName.getLocalName();
        Assert.isNotNull(string4);
        Assert.isTrue(!string4.equals(""));
        Document document = this.root.getOwnerDocument();
        Element element2 = document.createElement(string4);
        ResponseBody.declareNS(element2, null, string3);
        try {
            return this.accumulatePropStat(element2, string, string2);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public PropStat accumulatePropStat(Element element, String string, String string2) throws MalformedElementException {
        Object object;
        Assert.isNotNull(element);
        Assert.isNotNull(string);
        Element element2 = ResponseBody.getFirstChild(this.root, new String[]{"href", "status"});
        Assert.isTrue(element2 == null || ResponseBody.isDAVElement(element2, "href") && ResponseBody.getNextSibling(element2, new String[]{"href", "status"}) == null);
        boolean bl = false;
        Element element3 = ResponseBody.getFirstChild(this.root, "propstat");
        while (!bl && element3 != null) {
            object = ResponseBody.getChildText(element3, "status", false);
            if (object != null && ((String)object).equals(string)) {
                bl = true;
                continue;
            }
            element3 = ResponseBody.getTwin(element3, true);
        }
        object = null;
        if (element3 == null) {
            element3 = ResponseBody.addChild(this.root, "propstat", fgNamesPropStat, false);
            object = ResponseBody.setChild(element3, "prop", PropStat.childNames, true);
            ResponseBody.setChild(element3, "status", string, PropStat.childNames, false);
        } else {
            object = ResponseBody.getFirstChild(element3, "prop");
            if (object == null) {
                object = ResponseBody.setChild(element3, "prop", PropStat.childNames, true);
            }
        }
        if (string2 == null) {
            Element element4 = ResponseBody.getLastChild(element3, "responsedescription");
            if (element4 != null) {
                element3.removeChild(element4);
            }
        } else {
            ResponseBody.setChild(element3, "responsedescription", string2, PropStat.childNames, false);
        }
        ResponseBody.extractNode((Node)object, element);
        try {
            return new PropStat(element3);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public void addHref(String string) {
        Assert.isNotNull(string);
        Assert.isTrue(ResponseBody.getLastChild(this.root, "propstat") == null);
        ResponseBody.addChild(this.root, "href", ResponseBody.encodeHref(string), fgNamesStatus, false);
    }

    public PropStat addPropStat() {
        Element element = ResponseBody.getFirstChild(this.root, "href");
        Assert.isTrue(element == null || ResponseBody.getNextSibling(element, new String[]{"href", "status"}) == null);
        Element element2 = ResponseBody.addChild(this.root, "propstat", fgNamesPropStat, false);
        try {
            return new PropStat(element2);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public void changePropStatStatus(String string, String string2, String string3) {
        Assert.isNotNull(string);
        Assert.isNotNull(string2);
        Element element = ResponseBody.getFirstChild(this.root, "href");
        Assert.isTrue(element == null || ResponseBody.getNextSibling(element, new String[]{"href", "status"}) == null);
        Element element2 = ResponseBody.getFirstChild(this.root, "propstat");
        while (element2 != null) {
            String string4 = ResponseBody.getChildText(element2, "status", true);
            if (string.equals(string4)) {
                ResponseBody.setChild(element2, "status", string2, PropStat.childNames, true);
                if (string3 == null) {
                    Element element3 = ResponseBody.getLastChild(element2, "responsedescription");
                    if (element3 != null) {
                        element2.removeChild(element3);
                    }
                } else {
                    ResponseBody.setChild(element2, "responsedescription", string3, PropStat.childNames, false);
                }
            }
            element2 = ResponseBody.getTwin(element2, true);
        }
    }

    public static ResponseBody create(Document document) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getDocumentElement() == null);
        Element element = ResponseBody.create(document, "response");
        ResponseBody responseBody = null;
        try {
            responseBody = new ResponseBody(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return responseBody;
    }

    public String getHref() throws MalformedElementException {
        String string = ResponseBody.getChildText(this.root, "href", true);
        ResponseBody.ensureNotNull(Policy.bind("ensure.missingHrefElmt"), string);
        return ResponseBody.decodeHref(string);
    }

    public Enumeration getHrefs() throws MalformedElementException {
        Element element = ResponseBody.getFirstChild(this.root, "href");
        ResponseBody.ensureNotNull(Policy.bind("ensure.missingHrefElmt"), element);
        ResponseBody.ensureNotNull(Policy.bind("ensure.missingStatusElmt"), ResponseBody.getNextSibling(element, "status"));
        Enumeration enumeration = new Enumeration(element){
            Node currentHref;
            {
                this.currentHref = ResponseBody.getTwin((Element)node, true);
            }

            public boolean hasMoreElements() {
                return this.currentHref != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String string = ResponseBody.getFirstText((Element)this.currentHref);
                this.currentHref = ResponseBody.getTwin((Element)this.currentHref, true);
                return ResponseBody.decodeHref(string);
            }
        };
        return enumeration;
    }

    public Enumeration getPropStats() throws MalformedElementException {
        Element element = ResponseBody.getFirstChild(this.root, "propstat");
        ResponseBody.ensureNotNull("ensure.missingPropstatElmt", element);
        Enumeration enumeration = new Enumeration(element){
            Element currentPropStat;
            {
                this.currentPropStat = element;
            }

            public boolean hasMoreElements() {
                return this.currentPropStat != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                PropStat propStat = null;
                try {
                    propStat = new PropStat(this.currentPropStat);
                }
                catch (MalformedElementException malformedElementException) {
                    Assert.isTrue(false, Policy.bind("assert.internalError"));
                }
                this.currentPropStat = ResponseBody.getTwin(this.currentPropStat, true);
                return propStat;
            }
        };
        return enumeration;
    }

    public String getResponseDescription() throws MalformedElementException {
        return ResponseBody.getChildText(this.root, "responsedescription", false);
    }

    public String getStatus() throws MalformedElementException {
        Element element = ResponseBody.getFirstChild(this.root, "status");
        ResponseBody.ensureNotNull(Policy.bind("ensure.missingStatusElmt"), element);
        return ResponseBody.getFirstText(element);
    }

    public int getStatusCode() throws MalformedElementException {
        return new Status(this.getStatus()).getStatusCode();
    }

    public boolean isPropStat() throws MalformedElementException {
        Element element = ResponseBody.getFirstChild(this.root, new String[]{"status", "propstat"});
        ResponseBody.ensureNotNull(Policy.bind("ensure.missingStatusOrPropstatElmt"), element);
        boolean bl = ResponseBody.isDAVElement(element, "propstat");
        element = bl ? ResponseBody.getNextSibling(element, "status") : ResponseBody.getNextSibling(element, "propstat");
        ResponseBody.ensureNull(Policy.bind("ensure.conflictingStatusOrPropstatElmt"), element);
        return bl;
    }

    public boolean isStatus() throws MalformedElementException {
        return !this.isPropStat();
    }

    public void setHref(String string) {
        Assert.isNotNull(string);
        ResponseBody.setChild(this.root, "href", string, childNames, true);
    }

    public void setResponseDescription(String string) {
        if (string == null) {
            Element element = ResponseBody.getLastChild(this.root, "responsedescription");
            if (element != null) {
                this.root.removeChild(element);
            }
        } else {
            ResponseBody.setChild(this.root, "responsedescription", string, childNames, false);
        }
    }

    public void setResponseDescription(Element element) {
        Element element2 = ResponseBody.getLastChild(this.root, "responsedescription");
        if (element2 != null) {
            this.root.removeChild(element2);
        }
        if (element == null) {
            element2 = ResponseBody.setChild(this.root, "responsedescription", childNames, false);
            element2.appendChild(element);
        }
    }

    public void setStatus(String string) {
        Assert.isNotNull(string);
        Assert.isTrue(ResponseBody.getLastChild(this.root, "propstat") == null);
        ResponseBody.setChild(this.root, "status", string, fgNamesStatus, true);
    }
}

