/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.LockEntry;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Property;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SupportedLock
extends Property {
    protected static final String[] childNames = new String[]{"lockentry"};

    public SupportedLock(Element element) throws MalformedElementException {
        super(element, "supportedlock");
    }

    public LockEntry addLockEntry() {
        Element element = SupportedLock.addChild(this.root, "lockentry", childNames, false);
        Element element2 = SupportedLock.appendChild(element, "locktype");
        SupportedLock.appendChild(element2, "write");
        LockEntry lockEntry = null;
        try {
            lockEntry = new LockEntry(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return lockEntry;
    }

    public Enumeration getLockEntries() throws MalformedElementException {
        Element element = SupportedLock.getFirstChild(this.root, "lockentry");
        Enumeration enumeration = new Enumeration(element){
            Node currentLockEntry;
            {
                this.currentLockEntry = node;
            }

            public boolean hasMoreElements() {
                return this.currentLockEntry != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                LockEntry lockEntry = null;
                try {
                    lockEntry = new LockEntry((Element)this.currentLockEntry);
                }
                catch (MalformedElementException malformedElementException) {
                    Assert.isTrue(false, Policy.bind("assert.internalError"));
                }
                this.currentLockEntry = SupportedLock.getTwin((Element)this.currentLockEntry, true);
                return lockEntry;
            }
        };
        return enumeration;
    }
}

