/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Update
extends ElementEditor {
    public static String[] childNames = new String[]{"label-name", "version"};

    public Update(Element element) throws MalformedElementException {
        super(element, "set-target");
    }

    public static Update createLabel(Document document, String string) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getOwnerDocument() == null);
        Assert.isNotNull(string);
        Element element = Update.create(document, "update");
        try {
            Update update = new Update(element);
            update.setLabelName(string);
            return update;
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public static Update createVersion(Document document, String string) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getOwnerDocument() == null);
        Assert.isNotNull(string);
        Element element = Update.create(document, "update");
        try {
            Update update = new Update(element);
            update.setVersion(string);
            return update;
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public String getLabel() throws MalformedElementException {
        String string = Update.getChildText(this.root, "label", true);
        Update.ensureNotNull(Policy.bind("ensure.missingLabelElmt"), string);
        return string;
    }

    public String getVersion() throws MalformedElementException {
        Element element = Update.getFirstChild(this.root, "version");
        Update.ensureNotNull(Policy.bind("ensure.missingVersionElmt"), element);
        String string = Update.getChildText(element, "href", true);
        Update.ensureNotNull(Policy.bind("ensure.missingHrefElmt"), string);
        return Update.decodeHref(string);
    }

    public boolean isVersion() throws MalformedElementException {
        Element element = Update.getFirstChild(this.root, childNames);
        Update.ensureNotNull(Policy.bind("ensure.missingTargetDesc"), element);
        return Update.getNSLocalName(element).equals("version");
    }

    public void setLabelName(String string) throws MalformedElementException {
        Element element = Update.getFirstChild(this.root, childNames);
        if (Update.isDAVElement(element, "version")) {
            this.root.removeChild(element);
        }
        Update.setChild(element, "label-name", string, new String[]{"label-name"}, true);
    }

    public void setVersion(String string) throws MalformedElementException {
        Element element = Update.getFirstChild(this.root, childNames);
        if (Update.isDAVElement(element, "label-name")) {
            this.root.removeChild(element);
        }
        Element element2 = Update.setChild(this.root, "version", new String[]{"version"}, true);
        Update.setChild(element2, "href", Update.encodeHref(string), new String[]{"href"}, true);
    }
}

