/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.http.client;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class ContentType {
    private String contentType;
    private int position;
    private boolean foundDelim;
    private String type;
    private String subtype;
    private Hashtable parameters = new Hashtable(5);

    public ContentType(String string) throws IllegalArgumentException {
        Assert.isNotNull(string);
        this.contentType = string;
        this.position = 0;
        this.parse();
    }

    private void checkPosition() throws IllegalArgumentException {
        if (this.position >= this.contentType.length()) {
            this.illegalArgument();
        }
    }

    public Enumeration getAttributes() {
        return this.parameters.keys();
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getType() {
        return this.type;
    }

    public String getValue(String string) {
        return (String)this.parameters.get(string);
    }

    private void illegalArgument() throws IllegalArgumentException {
        throw new IllegalArgumentException(Policy.bind("exception.malformedContentType", this.contentType));
    }

    private String nextToken(char c, boolean bl) throws IllegalArgumentException {
        int n;
        int n2 = n = this.position;
        boolean bl2 = false;
        boolean bl3 = false;
        while (!bl2) {
            if (this.position == this.contentType.length()) {
                bl2 = true;
                this.foundDelim = false;
                continue;
            }
            char c2 = this.contentType.charAt(this.position);
            if (Character.isWhitespace(c2)) {
                if (bl) {
                    bl3 = true;
                } else {
                    this.illegalArgument();
                }
            } else if (c2 == c) {
                bl2 = true;
                this.foundDelim = true;
            } else {
                if (bl3) {
                    this.illegalArgument();
                }
                n2 = this.position + 1;
            }
            ++this.position;
        }
        return this.contentType.substring(n, n2);
    }

    private void parse() throws IllegalArgumentException {
        this.checkPosition();
        this.skipWhiteSpace();
        this.checkPosition();
        this.type = this.nextToken('/', false);
        this.checkPosition();
        this.subtype = this.nextToken(';', true);
        this.skipWhiteSpace();
        if (this.foundDelim) {
            this.checkPosition();
        }
        while (this.position < this.contentType.length()) {
            String string = this.nextToken('=', false);
            this.checkPosition();
            String string2 = this.nextToken(';', true);
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            this.skipWhiteSpace();
            if (this.foundDelim) {
                this.checkPosition();
            }
            this.parameters.put(string, string2);
        }
    }

    private void skipWhiteSpace() {
        while (this.position < this.contentType.length() && Character.isWhitespace(this.contentType.charAt(this.position))) {
            ++this.position;
        }
    }
}

