/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.http.client;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.client.WebDAVFactory;
import org.eclipse.webdav.http.client.HttpConnection;
import org.eclipse.webdav.http.client.IAuthenticator;
import org.eclipse.webdav.http.client.ISocketFactory;
import org.eclipse.webdav.http.client.IStatusCodes;
import org.eclipse.webdav.http.client.Message;
import org.eclipse.webdav.http.client.Request;
import org.eclipse.webdav.http.client.Response;
import org.eclipse.webdav.internal.authentication.AuthorizationAuthority;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class HttpClient
implements IStatusCodes {
    private double httpVersion = 1.1;
    private boolean closed = true;
    private ConnectionsRecycler connectionsRecycler = new ConnectionsRecycler("Connections Recycler");
    private AuthorizationAuthority authority = null;
    private Hashtable contexts = new Hashtable(5);
    private IContext defaultContext = null;
    private URL defaultProxyServerUrl = null;
    private Hashtable proxyServerUrls = new Hashtable(5);
    private Hashtable proxyServerExceptions = new Hashtable(5);
    private int maxRetries = 1;
    private int maxRedirects = 4;
    private int socketTimeout = 0;
    private ISocketFactory socketFactory = null;
    private WebDAVFactory webDAVFactory = new WebDAVFactory();

    public HttpClient() {
        this.open();
    }

    public void addProxyServerException(String string) {
        Assert.isNotNull(string);
        this.proxyServerExceptions.put(string, string);
    }

    public void close() {
        if (!this.closed) {
            this.connectionsRecycler.close();
            this.closed = true;
        }
    }

    public long getConnectionTimeout() {
        return this.connectionsRecycler.getConnectionTimeout();
    }

    public IContext getContext(URL uRL) {
        Assert.isNotNull(uRL);
        return (IContext)this.contexts.get(uRL);
    }

    public IContext getDefaultContext() {
        return this.defaultContext;
    }

    public URL getDefaultProxyServerUrl() {
        return this.defaultProxyServerUrl;
    }

    public double getHttpVersion() {
        return this.httpVersion;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Enumeration getOriginServerUrls() {
        final Enumeration enumeration = this.contexts.keys();
        final Enumeration enumeration2 = this.proxyServerUrls.keys();
        Enumeration enumeration3 = new Enumeration(){

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements() || enumeration2.hasMoreElements();
            }

            public Object nextElement() {
                if (enumeration.hasMoreElements()) {
                    return enumeration.nextElement();
                }
                return enumeration2.nextElement();
            }
        };
        return enumeration3;
    }

    public Enumeration getProxyServerExceptions() {
        return this.proxyServerExceptions.keys();
    }

    public URL getProxyServerUrl(URL uRL) {
        Assert.isNotNull(uRL);
        return (URL)this.proxyServerUrls.get(uRL);
    }

    public int getSoTimeout() {
        return this.socketTimeout;
    }

    public Response invoke(Request request) throws IOException {
        Assert.isNotNull(request);
        try {
            this.open();
            URL uRL = request.getResourceUrl();
            URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), "/");
            URL uRL3 = this.getProxyServerUrl(uRL2);
            if (uRL3 == null && !this.matchesProxyServerException(uRL2)) {
                uRL3 = this.getDefaultProxyServerUrl();
            }
            IContext iContext = this.webDAVFactory.newContext(request.getContext());
            IContext iContext2 = this.getContext(uRL2);
            if (iContext2 == null) {
                iContext2 = this.getDefaultContext();
            }
            if (iContext2 != null) {
                Enumeration enumeration = iContext2.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    iContext.put(string, iContext2.get(string));
                }
            }
            if (this.authority != null) {
                this.authority.authorize(request, null, iContext, uRL3, true);
                this.authority.authorize(request, null, iContext, uRL3, false);
            }
            Response response = this.invoke1(request, iContext, uRL3, uRL2, 0, 0);
            return response;
        }
        finally {
            request.close();
        }
    }

    private Response invoke1(Request request, IContext iContext, URL uRL, URL uRL2, int n, int n2) throws IOException {
        Message message = null;
        try {
            message = this.invoke2(request, iContext, uRL, uRL2, false);
            int n3 = ((Response)message).getStatusCode();
            if (n3 == 401 || n3 == 407) {
                if (this.authority == null || !this.authority.authorize(request, (IResponse)((Object)message), iContext, uRL, n3 == 407)) {
                    return message;
                }
                message.close();
                return this.invoke1(request, iContext, uRL, uRL2, 0, 0);
            }
            if (n3 >= 300 && n3 < 400) {
                if (n2 >= this.maxRedirects) {
                    return message;
                }
                String string = message.getContext().getLocation();
                if (string == null) {
                    return message;
                }
                URL uRL3 = new URL(string);
                if (n3 == 305) {
                    uRL = uRL3;
                } else {
                    uRL2 = new URL(uRL3.getProtocol(), uRL3.getHost(), uRL3.getPort(), "/");
                    request.setResourceUrl(uRL3);
                }
                message.close();
                return this.invoke1(request, iContext, uRL, uRL2, 0, n2 + 1);
            }
            if (this.authority != null) {
                this.authority.confirm(request, (IResponse)((Object)message), uRL);
            }
            return message;
        }
        catch (IOException iOException) {
            if (message != null) {
                message.close();
            }
            if (n < this.maxRetries) {
                return this.invoke1(request, iContext, uRL, uRL2, n + 1, 0);
            }
            throw iOException;
        }
    }

    private Response invoke2(Request request, IContext iContext, URL uRL, URL uRL2, boolean bl) throws IOException {
        HttpConnection httpConnection = null;
        try {
            httpConnection = this.connectionsRecycler.getConnection(uRL2);
            httpConnection.setHttpVersion(this.httpVersion);
            httpConnection.setRequestMethod(request.getMethod());
            httpConnection.setResourceUrl(request.getResourceUrl());
            httpConnection.setProxyServerUrl(uRL);
            httpConnection.clearRequestHeader();
            Enumeration enumeration = iContext.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                httpConnection.setRequestHeaderField(string, iContext.get(string));
            }
            long l = request.getContentLength();
            if (l >= 0L && iContext.getContentLength() == -1L) {
                httpConnection.setRequestHeaderField("Content-Length", "" + l);
            }
            String string = request.getMethod();
            boolean bl2 = l == -1L && this.httpVersion > 0.0 && !string.equals("PROPPATCH") && !string.equals("PROPFIND");
            httpConnection.setSendChunked(bl2);
            httpConnection.setPersistent(this.httpVersion > 0.0);
            httpConnection.setSoTimeout(this.socketTimeout);
            httpConnection.setSocketFactory(this.socketFactory);
            IContext iContext2 = null;
            if (bl && (l > 0L && this.httpVersion > 0.0 || bl2)) {
                if (!"100-continue".equalsIgnoreCase(iContext.get("Expect"))) {
                    httpConnection.setRequestHeaderField("Expect", "100-continue");
                }
                iContext2 = this.readResponseHeader(httpConnection);
                if (httpConnection.getStatusCode() != 100) {
                    return new Response(httpConnection.getStatusCode(), httpConnection.getStatusMessage(), iContext2, new PersistentInputStream(httpConnection));
                }
            }
            if (l != 0L) {
                OutputStream outputStream = httpConnection.getOutputStream();
                request.write(outputStream);
                outputStream.close();
            }
            iContext2 = this.readResponseHeader(httpConnection);
            return new Response(httpConnection.getStatusCode(), httpConnection.getStatusMessage(), iContext2, new PersistentInputStream(httpConnection));
        }
        catch (IOException iOException) {
            try {
                httpConnection.close();
            }
            catch (IOException iOException2) {}
            this.connectionsRecycler.putConnection(httpConnection);
            throw iOException;
        }
    }

    private boolean matchesProxyServerException(URL uRL) {
        String string = uRL.getHost();
        int n = uRL.getPort();
        String string2 = String.valueOf(string) + (n == -1 ? "" : ":" + n);
        boolean bl = false;
        Enumeration enumeration = this.proxyServerExceptions.keys();
        while (!bl && enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            int n2 = string3.length();
            bl = string2.equals(string3);
            if (bl) continue;
            if (string3.startsWith("*")) {
                bl = string2.endsWith(string3.substring(1, n2));
                continue;
            }
            if (!string3.endsWith("*")) continue;
            bl = string2.startsWith(string3.substring(0, n2 - 1));
        }
        return bl;
    }

    private void open() {
        if (this.closed) {
            this.connectionsRecycler.start();
            this.closed = false;
        }
    }

    private IContext readResponseHeader(HttpConnection httpConnection) throws IOException {
        IContext iContext = this.webDAVFactory.newContext();
        int n = 0;
        String string = null;
        while ((string = httpConnection.getResponseHeaderFieldName(n)) != null) {
            if (iContext.get(string.toLowerCase()) == null) {
                iContext.put(string.toLowerCase(), httpConnection.getResponseHeaderFieldValue(n));
            }
            ++n;
        }
        return iContext;
    }

    public void removeProxyServerException(String string) {
        Assert.isNotNull(string);
        this.proxyServerExceptions.remove(string);
    }

    public void setAuthenticator(IAuthenticator iAuthenticator) {
        this.authority = iAuthenticator == null ? null : new AuthorizationAuthority(iAuthenticator);
    }

    public void setConnectionTimeout(long l) {
        this.connectionsRecycler.setConnectionTimeout(l);
    }

    public void setContext(URL uRL, IContext iContext) {
        Assert.isNotNull(uRL);
        if (iContext == null) {
            this.contexts.remove(uRL);
        } else {
            this.contexts.put(uRL, iContext);
        }
    }

    public void setDefaultContext(IContext iContext) {
        this.defaultContext = iContext;
    }

    public void setDefaultProxyServerUrl(URL uRL) {
        this.defaultProxyServerUrl = uRL;
    }

    public void setHttpVersion(double d) {
        Assert.isTrue(d == 1.0 || d == 1.1);
        this.httpVersion = d;
    }

    public void setMaxRedirects(int n) {
        Assert.isTrue(n >= 0);
        this.maxRedirects = n;
    }

    public void setMaxRetries(int n) {
        Assert.isTrue(n >= 0);
        this.maxRetries = n;
    }

    public void setProxyServerUrl(URL uRL, URL uRL2) {
        Assert.isNotNull(uRL);
        if (uRL2 == null) {
            this.proxyServerUrls.remove(uRL);
        } else {
            this.proxyServerUrls.put(uRL, uRL2);
        }
    }

    public void setSocketFactory(ISocketFactory iSocketFactory) {
        this.socketFactory = iSocketFactory;
    }

    public void setSoTimeout(int n) {
        this.socketTimeout = n;
    }

    public class ConnectionsRecycler
    extends Thread {
        private long connectionTimeout;
        private Hashtable unusedConnections;
        private Hashtable usedConnections;

        public ConnectionsRecycler(String string) {
            super(string);
            this.connectionTimeout = 10000L;
            this.unusedConnections = new Hashtable(5);
            this.usedConnections = new Hashtable(5);
            this.setDaemon(true);
        }

        public synchronized void close() {
            this.interrupt();
            this.closeConnections(this.unusedConnections);
            this.closeConnections(this.usedConnections);
        }

        private synchronized void closeConnections(Hashtable hashtable) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                URL uRL = (URL)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(uRL);
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    HttpConnection httpConnection = (HttpConnection)enumeration2.nextElement();
                    try {
                        httpConnection.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            hashtable.clear();
        }

        public synchronized HttpConnection getConnection(URL uRL) {
            HttpConnection httpConnection = null;
            Vector vector = (Vector)this.unusedConnections.get(uRL);
            if (vector == null || vector.isEmpty()) {
                httpConnection = new HttpConnection(uRL);
            } else {
                httpConnection = (HttpConnection)vector.lastElement();
                vector.removeElementAt(vector.size() - 1);
            }
            Vector<HttpConnection> vector2 = (Vector<HttpConnection>)this.usedConnections.get(uRL);
            if (vector2 == null) {
                vector2 = new Vector<HttpConnection>(5);
                this.usedConnections.put(uRL, vector2);
            }
            vector2.addElement(httpConnection);
            httpConnection.setTimestamp(new Date());
            return httpConnection;
        }

        public long getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public synchronized void putConnection(HttpConnection httpConnection) {
            URL uRL = httpConnection.getResourceUrl();
            URL uRL2 = null;
            try {
                uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), "/");
            }
            catch (MalformedURLException malformedURLException) {}
            Vector vector = (Vector)this.usedConnections.get(uRL2);
            vector.remove(httpConnection);
            Vector<HttpConnection> vector2 = (Vector<HttpConnection>)this.unusedConnections.get(uRL2);
            if (vector2 == null) {
                vector2 = new Vector<HttpConnection>(5);
                this.unusedConnections.put(uRL2, vector2);
            }
            vector2.addElement(httpConnection);
            httpConnection.setTimestamp(new Date());
        }

        private synchronized void recycle() {
            Object object;
            Vector<Object> vector = new Vector<Object>(3);
            Enumeration enumeration = this.unusedConnections.keys();
            while (enumeration.hasMoreElements()) {
                HttpConnection httpConnection;
                object = (URL)enumeration.nextElement();
                Vector vector2 = (Vector)this.unusedConnections.get(object);
                if (vector2.isEmpty()) {
                    vector.add(object);
                    break;
                }
                Vector<HttpConnection> vector3 = new Vector<HttpConnection>(5);
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    long l;
                    httpConnection = (HttpConnection)enumeration2.nextElement();
                    long l2 = System.currentTimeMillis();
                    if (l2 - (l = httpConnection.getTimestamp().getTime()) < this.connectionTimeout) continue;
                    vector3.addElement(httpConnection);
                }
                enumeration2 = vector3.elements();
                while (enumeration2.hasMoreElements()) {
                    httpConnection = (HttpConnection)enumeration2.nextElement();
                    vector2.remove(httpConnection);
                    try {
                        httpConnection.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            object = vector.elements();
            while (object.hasMoreElements()) {
                this.unusedConnections.remove(object.nextElement());
            }
        }

        public void run() {
            while (!ConnectionsRecycler.interrupted()) {
                try {
                    Thread.sleep(this.connectionTimeout);
                    this.recycle();
                }
                catch (InterruptedException interruptedException) {
                    this.interrupt();
                }
            }
        }

        public void setConnectionTimeout(long l) {
            this.connectionTimeout = l;
        }
    }

    class PersistentInputStream
    extends FilterInputStream {
        private HttpConnection connection;

        PersistentInputStream(HttpConnection httpConnection) throws IOException {
            super(null);
            try {
                this.in = httpConnection.getInputStream();
            }
            catch (IOException iOException) {
                this.closeConnection();
                throw iOException;
            }
            this.connection = httpConnection;
        }

        public int available() throws IOException {
            try {
                return super.available();
            }
            catch (IOException iOException) {
                this.closeConnection();
                throw iOException;
            }
        }

        public void close() throws IOException {
            try {
                try {
                    super.close();
                }
                catch (IOException iOException) {
                    this.closeConnection();
                    throw iOException;
                }
            }
            finally {
                HttpClient.this.connectionsRecycler.putConnection(this.connection);
            }
        }

        private void closeConnection() {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {}
        }

        public int read() throws IOException {
            try {
                return super.read();
            }
            catch (IOException iOException) {
                this.closeConnection();
                throw iOException;
            }
        }

        public int read(byte[] byArray) throws IOException {
            try {
                return super.read(byArray);
            }
            catch (IOException iOException) {
                this.closeConnection();
                throw iOException;
            }
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            try {
                return super.read(byArray, n, n2);
            }
            catch (IOException iOException) {
                this.closeConnection();
                throw iOException;
            }
        }

        public synchronized void reset() throws IOException {
            try {
                super.reset();
            }
            catch (IOException iOException) {
                this.closeConnection();
                throw iOException;
            }
        }

        public long skip(long l) throws IOException {
            try {
                return super.skip(l);
            }
            catch (IOException iOException) {
                this.closeConnection();
                throw iOException;
            }
        }
    }
}

