/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.http.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Date;
import java.util.Vector;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.http.client.ISocketFactory;
import org.eclipse.webdav.http.client.IStatusCodes;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class HttpConnection
implements IStatusCodes {
    private double httpVersion = 1.1;
    private String method = "GET";
    private URL resourceUrl = null;
    private URL proxyServerUrl = null;
    protected Header requestHeader = new Header();
    protected Header responseHeader = new Header();
    protected Header internalHeader = new Header();
    private int statusCode;
    private String statusMessage;
    private ISocketFactory socketFactory = null;
    private Socket socket = null;
    private int receiveBufferSize = 0;
    private int sendBufferSize = 0;
    private int soLinger = -1;
    private int soTimeout = 0;
    private boolean tcpNoDelay = false;
    protected InputStream socketIn = null;
    protected OutputStream socketOut = null;
    private InputStream is = null;
    private OutputStream os = null;
    private boolean closeConnection;
    private boolean persistent = true;
    private boolean sendChunked = true;
    private boolean connected = false;
    private boolean sentRequest = false;
    private Date timestamp = null;

    public HttpConnection(URL uRL) {
        Assert.isNotNull(uRL);
        this.resourceUrl = uRL;
    }

    public HttpConnection(URL uRL, URL uRL2) {
        Assert.isNotNull(uRL);
        Assert.isNotNull(uRL2);
        this.proxyServerUrl = uRL;
        this.resourceUrl = uRL2;
    }

    public void clearRequestHeader() {
        this.endRequest();
        this.requestHeader.clear();
    }

    public void close() throws IOException {
        this.endRequest();
        if (this.connected) {
            this.connected = false;
            this.socket.close();
        }
    }

    private void connect() throws IOException {
        if (!this.connected) {
            int n;
            String string;
            String string2;
            if (this.proxyServerUrl == null) {
                string2 = this.resourceUrl.getProtocol();
                string = this.resourceUrl.getHost();
                n = this.getPort(this.resourceUrl);
            } else {
                string2 = this.proxyServerUrl.getProtocol();
                string = this.proxyServerUrl.getHost();
                n = this.getPort(this.proxyServerUrl);
            }
            this.socket = this.socketFactory == null ? new Socket(string, n) : this.socketFactory.createSocket(string2, string, n);
            if (this.receiveBufferSize > 0) {
                this.socket.setReceiveBufferSize(this.receiveBufferSize);
            }
            if (this.sendBufferSize > 0) {
                this.socket.setSendBufferSize(this.sendBufferSize);
            }
            this.socket.setSoLinger(this.soLinger >= 0, this.soLinger >= 0 ? this.soLinger : 0);
            this.socket.setSoTimeout(this.soTimeout);
            this.socket.setTcpNoDelay(this.tcpNoDelay);
            this.socketOut = new BufferedOutputStream(this.socket.getOutputStream());
            this.socketIn = new BufferedInputStream(this.socket.getInputStream());
            this.closeConnection = this.httpVersion == 1.0 || !this.persistent;
            this.connected = true;
        }
    }

    private void endRequest() {
        if (this.sentRequest) {
            boolean bl = false;
            if (this.os != null) {
                try {
                    this.os.close();
                }
                catch (IOException iOException) {
                    bl = true;
                }
            }
            try {
                this.getInputStream().close();
            }
            catch (IOException iOException) {
                bl = true;
            }
            this.sentRequest = false;
            if (this.closeConnection || bl) {
                try {
                    this.connected = false;
                    this.socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.os = null;
        this.is = null;
        this.internalHeader.clear();
    }

    public double getHttpVersion() {
        return this.httpVersion;
    }

    public InputStream getInputStream() throws IOException {
        if (this.is != null) {
            return this.is;
        }
        this.sendRequest();
        String string = this.responseHeader.getFieldValue("Transfer-Encoding");
        String string2 = this.responseHeader.getFieldValue("Content-Length");
        if ("chunked".equalsIgnoreCase(string)) {
            this.is = new ChunkedInputStream();
        } else if (this.method.equals("HEAD") && this.statusCode == 200) {
            this.is = new LimitedInputStream(0);
        } else if (string2 != null) {
            try {
                this.is = new LimitedInputStream(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
        } else if (this.statusCode >= 100 && this.statusCode < 200 || this.statusCode == 204 || this.statusCode == 304) {
            this.is = new LimitedInputStream(0);
        } else {
            this.closeConnection = true;
            this.is = this.socketIn;
        }
        return this.is;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.os != null) {
            return this.os;
        }
        String string = this.requestHeader.getFieldValue("Content-Length");
        if (this.sendChunked && this.httpVersion > 1.0) {
            this.os = new ChunkedOutputStream();
        } else if (string != null) {
            try {
                this.os = new LimitedOutputStream(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(Policy.bind("exception.malformedContentLength"));
            }
        } else {
            this.os = new CachedOutputStream();
            return this.os;
        }
        this.sendRequest();
        return this.os;
    }

    public boolean getPersistent() {
        return this.persistent;
    }

    private int getPort(URL uRL) {
        String string = uRL.getProtocol();
        int n = uRL.getPort();
        if (n == -1) {
            if (string.equals("http")) {
                return 80;
            }
            if (string.equals("https")) {
                return 443;
            }
            return -1;
        }
        return n;
    }

    public URL getProxyServerUrl() {
        return this.proxyServerUrl;
    }

    public int getReceiveBufferSize() throws IOException {
        if (this.connected) {
            return this.socket.getReceiveBufferSize();
        }
        return this.receiveBufferSize;
    }

    public String getRequestHeaderFieldValue(String string) {
        Assert.isNotNull(string);
        return this.requestHeader.getFieldValue(string);
    }

    public String getRequestMethod() {
        return this.method;
    }

    public URL getResourceUrl() {
        return this.resourceUrl;
    }

    public String getResponseHeaderFieldName(int n) throws IOException {
        Assert.isTrue(n >= 0);
        this.sendRequest();
        return this.responseHeader.getFieldName(n);
    }

    public String getResponseHeaderFieldValue(int n) throws IOException {
        Assert.isTrue(n >= 0);
        this.sendRequest();
        return this.responseHeader.getFieldValue(n);
    }

    public String getResponseHeaderFieldValue(String string) throws IOException {
        Assert.isNotNull(string);
        this.sendRequest();
        return this.responseHeader.getFieldValue(string);
    }

    public int getSendBufferSize() throws IOException {
        if (this.connected) {
            return this.socket.getSendBufferSize();
        }
        return this.sendBufferSize;
    }

    public boolean getSendChunked() {
        return this.sendChunked;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public int getStatusCode() throws IOException {
        this.sendRequest();
        return this.statusCode;
    }

    public String getStatusMessage() throws IOException {
        this.sendRequest();
        return this.statusMessage;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    protected void output(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes("UTF8"));
    }

    protected void readHeader(Header header) throws IOException {
        String string = null;
        while ((string = this.readln()).length() > 0) {
            int n = string.indexOf(":");
            if (n < 0) {
                throw new IOException(Policy.bind("exception.malformedHeaderField"));
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1).trim();
            header.addField(string2, string3);
        }
        String string4 = header.getFieldValue("Connection");
        if (string4 != null && string4.equalsIgnoreCase("close")) {
            this.closeConnection = true;
        }
    }

    protected String readln() throws IOException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = this.socketIn.read()) < 0) {
                throw new IOException(Policy.bind("exception.unexpectedEndStream"));
            }
            if (bl) {
                if (n == 10) break;
                stringBuffer.append('\r');
            }
            if (n == 13) {
                bl = true;
                continue;
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    protected void readServerResponse() throws IOException {
        double d;
        this.socketOut.flush();
        String string = this.readln();
        if (!string.startsWith("HTTP/")) {
            throw new IOException(Policy.bind("exception.malformedStatusLine"));
        }
        int n = string.indexOf(32, 5);
        if (n == -1) {
            throw new IOException(Policy.bind("exception.malformedStatusLine"));
        }
        int n2 = string.indexOf(32, n + 1);
        if (n2 == -1) {
            throw new IOException(Policy.bind("exception.malformedStatusLine"));
        }
        try {
            d = Double.parseDouble(string.substring(5, n));
            this.statusCode = Integer.parseInt(string.substring(n + 1, n2));
            this.statusMessage = string.substring(n2 + 1);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(Policy.bind("exception.malformedStatusLine"));
        }
        if (d == 1.0) {
            this.httpVersion = 1.0;
            this.closeConnection = true;
        }
        this.responseHeader.clear();
        this.readHeader(this.responseHeader);
    }

    protected void sendRequest() throws IOException {
        if (this.sentRequest) {
            return;
        }
        this.connect();
        if (this.requestHeader.getFieldValue("Host") == null) {
            this.internalHeader.addField("Host", String.valueOf(this.resourceUrl.getHost()) + (this.resourceUrl.getPort() == -1 ? "" : ":" + this.resourceUrl.getPort()));
        }
        if (this.httpVersion > 1.0 && !this.persistent && this.requestHeader.getFieldValue("Connection") == null) {
            this.internalHeader.addField("Connection", "close");
        }
        if (this.os != null || "100-continue".equals(this.requestHeader.getFieldValue("Expect"))) {
            if (this.requestHeader.getFieldValue("Content-Type") == null) {
                this.internalHeader.addField("Content-Type", "application/x-www-form-urlencoded");
            }
            if (this.httpVersion > 1.0 && this.sendChunked) {
                this.internalHeader.addField("Transfer-Encoding", "chunked");
            }
        }
        this.output(this.socketOut, this.method);
        this.output(this.socketOut, " ");
        this.output(this.socketOut, this.proxyServerUrl == null ? this.resourceUrl.getFile() : this.resourceUrl.toString());
        this.output(this.socketOut, " HTTP/1.1\r\n");
        this.writeHeader(this.internalHeader);
        this.writeHeader(this.requestHeader);
        this.output(this.socketOut, "\r\n");
        this.sentRequest = true;
        if (this.os == null) {
            this.readServerResponse();
        }
    }

    public void setHttpVersion(double d) {
        Assert.isTrue(d == 1.0 || d == 1.1);
        this.endRequest();
        this.httpVersion = d;
    }

    public void setPersistent(boolean bl) {
        this.endRequest();
        this.persistent = bl;
    }

    public void setProxyServerUrl(URL uRL) {
        this.endRequest();
        if (uRL == null && this.proxyServerUrl == null) {
            return;
        }
        boolean bl = true;
        if (uRL != null && this.proxyServerUrl != null) {
            URL uRL2 = null;
            URL uRL3 = null;
            try {
                uRL2 = new URL(this.proxyServerUrl.getProtocol(), this.proxyServerUrl.getHost(), this.proxyServerUrl.getPort(), "/");
                uRL3 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), "/");
            }
            catch (MalformedURLException malformedURLException) {}
            if (uRL2.equals(uRL3)) {
                bl = false;
            }
        }
        if (bl) {
            try {
                this.close();
            }
            catch (IOException iOException) {}
        }
        this.proxyServerUrl = uRL;
    }

    public void setReceiveBufferSize(int n) throws IOException {
        Assert.isTrue(n > 0);
        if (n != this.getReceiveBufferSize()) {
            this.receiveBufferSize = n;
            if (this.connected) {
                this.socket.setReceiveBufferSize(this.receiveBufferSize);
            }
        }
    }

    public void setRequestHeaderField(String string, String string2) {
        Assert.isNotNull(string);
        Assert.isNotNull(string2);
        this.endRequest();
        this.requestHeader.addField(string, string2);
    }

    public void setRequestMethod(String string) {
        Assert.isNotNull(string);
        this.endRequest();
        this.method = string;
    }

    public void setResourceUrl(URL uRL) {
        Assert.isNotNull(uRL);
        this.endRequest();
        URL uRL2 = null;
        URL uRL3 = null;
        try {
            uRL2 = new URL(this.resourceUrl.getProtocol(), this.resourceUrl.getHost(), this.resourceUrl.getPort(), "/");
            uRL3 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), "/");
        }
        catch (MalformedURLException malformedURLException) {}
        if (!uRL2.equals(uRL3)) {
            try {
                this.close();
            }
            catch (IOException iOException) {}
        }
        this.resourceUrl = uRL;
    }

    public void setSendBufferSize(int n) throws IOException {
        Assert.isTrue(n > 0);
        if (n != this.getSendBufferSize()) {
            this.sendBufferSize = n;
            if (this.connected) {
                this.socket.setSendBufferSize(this.sendBufferSize);
            }
        }
    }

    public void setSendChunked(boolean bl) {
        this.endRequest();
        this.sendChunked = bl;
    }

    public void setSocketFactory(ISocketFactory iSocketFactory) {
        this.endRequest();
        if (iSocketFactory == this.socketFactory) {
            return;
        }
        try {
            this.close();
        }
        catch (IOException iOException) {}
        this.socketFactory = iSocketFactory;
    }

    public void setSoLinger(boolean bl, int n) throws IOException {
        Assert.isTrue(n >= 0);
        if (!bl && this.soLinger != -1 || bl && n != this.soLinger) {
            int n2 = this.soLinger = bl ? n : -1;
            if (this.connected) {
                this.socket.setSoLinger(bl, n);
            }
        }
    }

    public void setSoTimeout(int n) throws IOException {
        Assert.isTrue(n >= 0);
        if (n != this.soTimeout) {
            this.soTimeout = n;
            if (this.connected) {
                this.socket.setSoTimeout(this.soTimeout);
            }
        }
    }

    public void setTcpNoDelay(boolean bl) throws IOException {
        if (bl != this.tcpNoDelay) {
            this.tcpNoDelay = bl;
            if (this.connected) {
                this.socket.setTcpNoDelay(this.tcpNoDelay);
            }
        }
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    private void writeHeader(Header header) throws IOException {
        int n = 0;
        while (n < header.size()) {
            String string = header.getFieldName(n);
            String string2 = header.getFieldValue(string);
            this.output(this.socketOut, string);
            this.output(this.socketOut, ": ");
            this.output(this.socketOut, string2);
            this.output(this.socketOut, "\r\n");
            ++n;
        }
    }

    private class CachedOutputStream
    extends OutputStream {
        private static final int INITIAL_CACHE_SIZE = 1024;
        private ByteArrayOutputStream cache = new ByteArrayOutputStream(1024);
        private boolean closed = false;

        private CachedOutputStream() {
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                String string = Integer.toString(this.cache.size());
                HttpConnection.this.internalHeader.addField("Content-Length", string);
                HttpConnection.this.sendRequest();
                this.cache.writeTo(HttpConnection.this.socketOut);
                HttpConnection.this.readServerResponse();
            }
            finally {
                this.closed = true;
            }
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException(Policy.bind("exception.closed"));
            }
        }

        public void write(int n) throws IOException {
            if (this.closed) {
                throw new IOException(Policy.bind("exception.closed"));
            }
            this.cache.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException(Policy.bind("exception.closed"));
            }
            this.cache.write(byArray, n, n2);
        }
    }

    private class ChunkedInputStream
    extends InputStream {
        private int bytesRemaining = -1;
        private boolean atEnd = false;

        private ChunkedInputStream() {
        }

        public int available() throws IOException {
            return Math.min(HttpConnection.this.socketIn.available(), this.bytesRemaining);
        }

        public void close() throws IOException {
            while (this.skip(4096) > 0L) {
            }
        }

        public int read() throws IOException {
            if (!this.atEnd && this.bytesRemaining <= 0) {
                this.readChunkSize();
            }
            if (this.atEnd) {
                return -1;
            }
            --this.bytesRemaining;
            return HttpConnection.this.socketIn.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (!this.atEnd && this.bytesRemaining <= 0) {
                this.readChunkSize();
            }
            if (this.atEnd) {
                return -1;
            }
            int n3 = HttpConnection.this.socketIn.read(byArray, n, Math.min(n2, this.bytesRemaining));
            if (n3 > 0) {
                this.bytesRemaining -= n3;
            }
            return n3;
        }

        private void readChunkSize() throws IOException {
            String string;
            int n;
            if (this.bytesRemaining == 0) {
                HttpConnection.this.readln();
            }
            if ((n = (string = HttpConnection.this.readln()).indexOf(";")) >= 0) {
                string = string.substring(0, n);
            }
            try {
                this.bytesRemaining = Integer.parseInt(string.trim(), 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
            if (this.bytesRemaining == 0) {
                this.atEnd = true;
                HttpConnection.this.readHeader(HttpConnection.this.responseHeader);
            }
        }

        public long skip(int n) throws IOException {
            if (!this.atEnd && this.bytesRemaining <= 0) {
                this.readChunkSize();
            }
            if (this.atEnd) {
                return -1L;
            }
            long l = HttpConnection.this.socketIn.skip(Math.min(n, this.bytesRemaining));
            if (l > 0L) {
                this.bytesRemaining = (int)((long)this.bytesRemaining - l);
            }
            return l;
        }
    }

    private class ChunkedOutputStream
    extends OutputStream {
        private static final int MAX_BUFFER_SIZE = 1024;
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);
        private boolean closed = false;

        private ChunkedOutputStream() {
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                this.sendBuffer();
                HttpConnection.this.output(HttpConnection.this.socketOut, "0\r\n\r\n");
                HttpConnection.this.readServerResponse();
            }
            finally {
                this.closed = true;
            }
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            this.sendBuffer();
            HttpConnection.this.socketOut.flush();
        }

        public void sendBuffer() throws IOException {
            int n = this.buffer.size();
            if (n > 0) {
                HttpConnection.this.output(HttpConnection.this.socketOut, String.valueOf(Integer.toHexString(n)) + "\r\n");
                this.buffer.writeTo(HttpConnection.this.socketOut);
                this.buffer.reset();
                HttpConnection.this.output(HttpConnection.this.socketOut, "\r\n");
            }
        }

        public void write(int n) throws IOException {
            if (this.closed) {
                throw new IOException(Policy.bind("exception.closed"));
            }
            this.buffer.write(n);
            if (this.buffer.size() >= 1024) {
                this.sendBuffer();
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException(Policy.bind("exception.closed"));
            }
            int n3 = this.buffer.size();
            if (n3 + n2 < 1024) {
                this.buffer.write(byArray, n, n2);
            } else {
                HttpConnection.this.output(HttpConnection.this.socketOut, String.valueOf(Integer.toHexString(n3 + n2)) + "\r\n");
                this.buffer.writeTo(HttpConnection.this.socketOut);
                this.buffer.reset();
                HttpConnection.this.socketOut.write(byArray, n, n2);
                HttpConnection.this.output(HttpConnection.this.socketOut, "\r\n");
            }
        }
    }

    public class Header {
        private Vector fieldNames = new Vector(5);
        private Vector fieldValues = new Vector(5);

        public void addField(String string, String string2) {
            Assert.isNotNull(string);
            Assert.isNotNull(string2);
            this.fieldNames.addElement(string);
            this.fieldValues.addElement(string2);
        }

        public void clear() {
            this.fieldNames.removeAllElements();
            this.fieldValues.removeAllElements();
        }

        public String getFieldValue(int n) {
            if (n < 0 || n >= this.fieldValues.size()) {
                return null;
            }
            return (String)this.fieldValues.elementAt(n);
        }

        public String getFieldValue(String string) {
            Assert.isNotNull(string);
            return this.getFieldValue(this.fieldNames.indexOf(string));
        }

        public String getFieldName(int n) {
            if (n < 0 || n >= this.fieldNames.size()) {
                return null;
            }
            return (String)this.fieldNames.elementAt(n);
        }

        public int size() {
            return this.fieldNames.size();
        }
    }

    private class LimitedInputStream
    extends InputStream {
        private int bytesRemaining;

        public LimitedInputStream(int n) {
            Assert.isTrue(n >= 0);
            this.bytesRemaining = n;
        }

        public int available() throws IOException {
            return Math.min(HttpConnection.this.socketIn.available(), this.bytesRemaining);
        }

        public void close() throws IOException {
            while (this.skip(4096) > 0L) {
            }
        }

        public int read() throws IOException {
            if (this.bytesRemaining <= 0) {
                return -1;
            }
            --this.bytesRemaining;
            return HttpConnection.this.socketIn.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.bytesRemaining <= 0) {
                return -1;
            }
            int n3 = HttpConnection.this.socketIn.read(byArray, n, Math.min(n2, this.bytesRemaining));
            if (n3 > 0) {
                this.bytesRemaining -= n3;
            }
            return n3;
        }

        public long skip(int n) throws IOException {
            if (this.bytesRemaining <= 0) {
                return -1L;
            }
            long l = HttpConnection.this.socketIn.skip(Math.min(n, this.bytesRemaining));
            if (l > 0L) {
                this.bytesRemaining = (int)((long)this.bytesRemaining - l);
            }
            return l;
        }
    }

    private class LimitedOutputStream
    extends OutputStream {
        private int limit;
        private boolean closed = false;

        public LimitedOutputStream(int n) {
            Assert.isTrue(n >= 0);
            this.limit = n;
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                this.flush();
                if (this.limit > 0) {
                    throw new IOException(Policy.bind("exception.contentLengthUnderflow"));
                }
                HttpConnection.this.readServerResponse();
            }
            finally {
                this.closed = true;
            }
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException(Policy.bind("exception.closed"));
            }
            HttpConnection.this.socketOut.flush();
        }

        public void write(int n) throws IOException {
            if (this.closed) {
                throw new IOException(Policy.bind("exception.closed"));
            }
            if (this.limit == 0) {
                throw new IOException(Policy.bind("exception.contentLengthExceeded"));
            }
            --this.limit;
            HttpConnection.this.socketOut.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException(Policy.bind("exception.closed"));
            }
            if (n2 > this.limit) {
                throw new IOException(Policy.bind("exception.contentLengthExceeded"));
            }
            this.limit -= n2;
            HttpConnection.this.socketOut.write(byArray, n, n2);
        }
    }
}

