/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.http.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.client.WebDAVFactory;
import org.eclipse.webdav.http.client.BufferPool;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public abstract class Message {
    protected static BufferPool bufferPool = new BufferPool();
    protected InputStream is;
    protected boolean inputRead = false;
    protected boolean hasInputStream = false;
    protected IContext context;

    public Message(IContext iContext, InputStream inputStream) {
        this.context = iContext;
        if (iContext == null) {
            this.context = WebDAVFactory.contextFactory.newContext();
        }
        this.is = inputStream;
        if (inputStream == null) {
            this.is = new ByteArrayInputStream(new byte[0]);
        }
    }

    public void close() throws IOException {
        this.is.close();
    }

    public long getContentLength() {
        long l = this.context.getContentLength();
        if (l != -1L) {
            return l;
        }
        if (this.is instanceof ByteArrayInputStream) {
            return ((ByteArrayInputStream)this.is).available();
        }
        return -1L;
    }

    public IContext getContext() {
        return this.context;
    }

    public InputStream getInputStream() {
        this.hasInputStream = true;
        return this.is;
    }

    public String toString() {
        return this.context.toString();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(OutputStream outputStream) throws IOException {
        Assert.isTrue(!this.inputRead);
        Assert.isTrue(!this.hasInputStream);
        int n = 0;
        int n2 = 0;
        byte[] byArray = bufferPool.getBuffer();
        long l = this.getContentLength();
        try {
            block9: {
                block8: {
                    if (!true) break block8;
                    if (n == -1) return;
                    if (l != -1L && l <= (long)n2) break block9;
                }
                do {
                    if ((n = l == -1L ? this.is.read(byArray) : this.is.read(byArray, 0, (int)Math.min((long)byArray.length, l - (long)n2))) == -1) {
                        if (l >= 0L) {
                            throw new IOException(Policy.bind("exception.unexpectedEndStream"));
                        }
                    } else {
                        n2 += n;
                        outputStream.write(byArray, 0, n);
                    }
                    if (n == -1) return;
                } while (l == -1L || l > (long)n2);
            }
            return;
        }
        finally {
            bufferPool.putBuffer(byArray);
            this.inputRead = true;
        }
    }
}

