/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.http.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.http.client.IRequestBodyWriter;
import org.eclipse.webdav.http.client.Message;
import org.eclipse.webdav.http.client.RequestInputStream;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class Request
extends Message {
    private String method;
    private URL resourceUrl;
    private IRequestBodyWriter requestBodyWriter;

    public Request(String string, URL uRL, IContext iContext) {
        super(iContext, new RequestInputStream(new byte[0]));
        Assert.isNotNull(string);
        Assert.isNotNull(uRL);
        this.method = string;
        this.resourceUrl = uRL;
    }

    public Request(String string, URL uRL, IContext iContext, InputStream inputStream) throws IOException {
        super(iContext, inputStream == null ? new RequestInputStream(new byte[0]) : (inputStream instanceof RequestInputStream ? inputStream : (inputStream instanceof ByteArrayInputStream ? new RequestInputStream((ByteArrayInputStream)inputStream) : new RequestInputStream(inputStream, -1L))));
        Assert.isNotNull(string);
        Assert.isNotNull(uRL);
        this.method = string;
        this.resourceUrl = uRL;
    }

    public Request(String string, URL uRL, IContext iContext, IRequestBodyWriter iRequestBodyWriter) {
        super(iContext, new RequestInputStream(new byte[0]));
        Assert.isNotNull(string);
        Assert.isNotNull(uRL);
        Assert.isNotNull(iRequestBodyWriter);
        this.method = string;
        this.resourceUrl = uRL;
        this.requestBodyWriter = iRequestBodyWriter;
    }

    public long getContentLength() {
        long l = super.getContentLength();
        if (l != -1L) {
            return l;
        }
        if (this.requestBodyWriter == null) {
            return ((RequestInputStream)this.is).length();
        }
        return -1L;
    }

    public String getMethod() {
        return this.method;
    }

    public IRequestBodyWriter getRequestBodyWriter() {
        return this.requestBodyWriter;
    }

    public URL getResourceUrl() {
        return this.resourceUrl;
    }

    void setResourceUrl(URL uRL) {
        this.resourceUrl = uRL;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.method);
        stringBuffer.append(' ');
        stringBuffer.append(this.resourceUrl);
        stringBuffer.append('\n');
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.requestBodyWriter == null) {
            if (this.inputRead) {
                this.is.reset();
                this.inputRead = false;
            }
            super.write(outputStream);
        } else {
            this.requestBodyWriter.writeRequestBody(outputStream);
        }
    }
}

