/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.http.client;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class RequestInputStream
extends InputStream {
    private long length = -1L;
    private long totalBytesRead = 0L;
    private InputStream is = null;
    private File file = null;
    private FileOutputStream fos = null;
    private boolean deleteFile = false;

    public RequestInputStream(byte[] byArray) {
        this.length = byArray.length;
        this.is = new ByteArrayInputStream(byArray);
    }

    public RequestInputStream(ByteArrayInputStream byteArrayInputStream) {
        Assert.isNotNull(byteArrayInputStream);
        this.length = byteArrayInputStream.available();
        this.is = byteArrayInputStream;
    }

    public RequestInputStream(File file) throws IOException {
        Assert.isNotNull(file);
        this.length = file.length();
        this.is = new FileInputStream(file);
        this.file = file;
    }

    public RequestInputStream(InputStream inputStream, long l) throws IOException {
        Assert.isNotNull(inputStream);
        Assert.isTrue(l >= -1L);
        this.length = l;
        this.is = inputStream;
        this.file = File.createTempFile("ris", ".tmp");
        this.fos = new FileOutputStream(this.file);
        this.deleteFile = true;
    }

    public void close() throws IOException {
        this.is.close();
        if (this.fos != null) {
            this.fos.close();
        }
        if (this.deleteFile) {
            this.file.delete();
        }
    }

    public long length() {
        return this.length;
    }

    public int read() throws IOException {
        int n = this.is.read();
        if (n == -1) {
            if (this.length != -1L && this.totalBytesRead < this.length) {
                throw new IOException(Policy.bind("exception.unexpectedEndStream"));
            }
        } else {
            ++this.totalBytesRead;
            if (this.fos != null) {
                this.fos.write(n);
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.is.read(byArray, n, n2);
        if (n3 == -1) {
            if (this.length != -1L && this.totalBytesRead < this.length) {
                throw new IOException(Policy.bind("exception.unexpectedEndStream"));
            }
        } else {
            this.totalBytesRead += (long)n3;
            if (this.fos != null) {
                this.fos.write(byArray, n, n2);
            }
        }
        return n3;
    }

    public void reset() throws IOException {
        if (this.file == null) {
            ((ByteArrayInputStream)this.is).reset();
        } else {
            if (this.fos != null) {
                while (this.skip(4096L) > 0L) {
                }
                this.fos.close();
                this.fos = null;
                if (this.length == -1L) {
                    this.length = this.totalBytesRead;
                }
            }
            this.is.close();
            this.is = new FileInputStream(this.file);
        }
        this.totalBytesRead = 0L;
    }
}

