/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.http.client.ContentType;
import org.eclipse.webdav.http.client.IStatusCodes;
import org.eclipse.webdav.http.client.Message;
import org.eclipse.webdav.internal.kernel.DocumentMarshaler;
import org.eclipse.webdav.internal.kernel.utils.Assert;
import org.w3c.dom.Document;

public class Response
extends Message
implements IResponse,
IStatusCodes {
    protected int statusCode;
    protected String statusMessage;
    protected boolean hasDocumentBody;
    protected Document document;

    public Response(int n, String string, IContext iContext, InputStream inputStream) {
        super(iContext, inputStream);
        Assert.isTrue(n >= 100 && n < 600);
        Assert.isNotNull(string);
        this.statusCode = n;
        this.statusMessage = string;
        this.hasDocumentBody = false;
        ContentType contentType = this.getContentType();
        if (contentType != null) {
            this.hasDocumentBody = "xml".equals(contentType.getSubtype());
        }
    }

    public long getContentLength() {
        long l = this.context.getContentLength();
        if (l != -1L) {
            return l;
        }
        int n = this.getStatusCode();
        if (n == 204 || n == 304 || n >= 100 && n < 200) {
            return 0L;
        }
        return -1L;
    }

    public ContentType getContentType() {
        String string = this.context.getContentType();
        if (string == null) {
            return null;
        }
        ContentType contentType = null;
        try {
            contentType = new ContentType(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return contentType;
    }

    public Document getDocumentBody() throws IOException {
        Assert.isTrue(this.hasDocumentBody);
        Assert.isTrue(!this.hasInputStream);
        if (this.document == null) {
            String string = null;
            ContentType contentType = this.getContentType();
            if (contentType != null) {
                string = contentType.getValue("charset");
            }
            if (string == null) {
                string = "ASCII";
            }
            DocumentMarshaler documentMarshaler = new DocumentMarshaler();
            this.document = documentMarshaler.parse(new InputStreamReader(this.is, string));
        }
        return this.document;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public boolean hasDocumentBody() {
        return this.hasDocumentBody;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.statusCode);
        stringBuffer.append(' ');
        stringBuffer.append(this.statusMessage);
        stringBuffer.append('\n');
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

