/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.authentication;

import java.util.Hashtable;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.internal.authentication.Parser;
import org.eclipse.webdav.internal.authentication.ParserException;

public class AuthenticateChallenge {
    private String challenge;
    private Parser parser;
    private String authScheme;
    private Hashtable authParams;

    public AuthenticateChallenge(String string) throws ParserException {
        this.challenge = string;
        this.parser = new Parser(string);
        this.parse();
    }

    public String get(String string) {
        return (String)this.authParams.get(string);
    }

    public String getAuthScheme() {
        return this.authScheme;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public String getRealm() {
        return this.get("realm");
    }

    private void parse() throws ParserException {
        this.authParams = new Hashtable(5);
        this.authScheme = this.parser.nextToken();
        this.parser.skipWhiteSpace();
        boolean bl = false;
        while (!bl) {
            String string = this.parser.nextToken();
            this.parser.match('=');
            String string2 = null;
            this.parser.checkPosition();
            string2 = this.challenge.charAt(this.parser.pos) == '\"' ? this.parser.nextQuotedString() : this.parser.nextToken();
            this.authParams.put(string, string2);
            this.parser.skipWhiteSpace();
            boolean bl2 = bl = this.parser.pos == this.challenge.length();
            if (bl) continue;
            this.parser.match(',');
            this.parser.skipWhiteSpace();
        }
        if (this.getRealm() == null) {
            throw new ParserException(Policy.bind("exception.missingRealm"));
        }
    }
}

