/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.authentication;

import java.util.Hashtable;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.internal.authentication.Parser;
import org.eclipse.webdav.internal.authentication.ParserException;

public class AuthenticationInfo {
    private String authInfo;
    private Parser parser;
    private Hashtable info;

    public AuthenticationInfo(String string) throws ParserException {
        this.authInfo = string;
        this.parser = new Parser(string);
        this.parse();
    }

    public String getCNonce() {
        return (String)this.info.get("cnonce");
    }

    public String getMessageQop() {
        return (String)this.info.get("qop");
    }

    public String getNextNonce() {
        return (String)this.info.get("nextnonce");
    }

    public String getNonceCount() {
        return (String)this.info.get("nc");
    }

    public String getResponseAuth() {
        return (String)this.info.get("rspauth");
    }

    private void parse() throws ParserException {
        this.info = new Hashtable(5);
        boolean bl = false;
        while (!bl) {
            String string = this.parser.nextToken();
            this.parser.match('=');
            String string2 = null;
            this.parser.checkPosition();
            string2 = this.authInfo.charAt(this.parser.pos) == '\"' ? this.parser.nextQuotedString() : this.parser.nextToken();
            this.info.put(string, string2);
            this.parser.skipWhiteSpace();
            boolean bl2 = bl = this.parser.pos == this.authInfo.length();
            if (bl) continue;
            this.parser.match(',');
            this.parser.skipWhiteSpace();
        }
        if (this.getNextNonce() == null) {
            throw new ParserException(Policy.bind("exception.missingNextnonce"));
        }
    }
}

