/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.authentication;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.http.client.IAuthenticator;
import org.eclipse.webdav.http.client.Request;
import org.eclipse.webdav.internal.authentication.AuthenticateChallenge;
import org.eclipse.webdav.internal.authentication.DigestOutputStream;
import org.eclipse.webdav.internal.authentication.HexConverter;
import org.eclipse.webdav.internal.authentication.ParserException;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class AuthorizationAuthority {
    public static String[] authenticationSchemes = new String[]{"Digest", "Basic"};
    protected IAuthenticator authenticatorStore = null;

    public AuthorizationAuthority(IAuthenticator iAuthenticator) {
        Assert.isNotNull(iAuthenticator);
        this.authenticatorStore = iAuthenticator;
    }

    public boolean authorize(Request request, IResponse iResponse, IContext iContext, URL uRL, boolean bl) {
        Object object;
        String string;
        Object object2;
        Object object3;
        Assert.isNotNull(request);
        Assert.isNotNull(iContext);
        URL uRL2 = null;
        Object object4 = null;
        if (bl) {
            if (uRL == null) {
                return false;
            }
            uRL2 = uRL;
            object4 = uRL;
        } else {
            object3 = request.getResourceUrl();
            try {
                uRL2 = new URL(((URL)object3).getProtocol(), ((URL)object3).getHost(), ((URL)object3).getPort(), "/");
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
            object4 = object3;
        }
        if (iResponse != null) {
            object3 = null;
            object3 = bl ? iResponse.getContext().getProxyAuthenticate() : iResponse.getContext().getWWWAuthenticate();
            if (object3 == null) {
                return false;
            }
            object2 = null;
            try {
                object2 = new AuthenticateChallenge((String)object3);
            }
            catch (ParserException parserException) {
                return false;
            }
            string = ((AuthenticateChallenge)object2).getAuthScheme();
            String string2 = ((AuthenticateChallenge)object2).getRealm();
            object = this.getAuthorizationAuthority(string);
            if (object == null) {
                return false;
            }
            Map map = this.authenticatorStore.getAuthenticationInfo(uRL2, string2, string);
            Map map2 = ((AuthorizationAuthority)object).getAuthenticationInfo((AuthenticateChallenge)object2, map, uRL2, (URL)object4);
            if (map2 == null) {
                return false;
            }
            this.authenticatorStore.addAuthenticationInfo(uRL2, string2, string, map2);
            this.authenticatorStore.addProtectionSpace((URL)object4, string2);
        }
        if ((object3 = this.authenticatorStore.getProtectionSpace((URL)object4)) == null) {
            return false;
        }
        object2 = null;
        string = null;
        int n = 0;
        while (n < authenticationSchemes.length) {
            string = authenticationSchemes[n];
            object2 = this.authenticatorStore.getAuthenticationInfo(uRL2, (String)object3, string);
            if (object2 != null) break;
            ++n;
        }
        if (object2 == null) {
            return false;
        }
        AuthorizationAuthority authorizationAuthority = this.getAuthorizationAuthority(string);
        if (authorizationAuthority == null) {
            return false;
        }
        object = authorizationAuthority.getAuthorization(request, (Map)object2, uRL2, (URL)object4, uRL);
        if (object == null) {
            return false;
        }
        if (bl) {
            if (((String)object).equals(iContext.getProxyAuthorization())) {
                return false;
            }
            iContext.setProxyAuthorization((String)object);
        } else {
            if (((String)object).equals(iContext.getAuthorization())) {
                return false;
            }
            iContext.setAuthorization((String)object);
        }
        return true;
    }

    public boolean confirm(Request request, IResponse iResponse, URL uRL) {
        Assert.isNotNull(request);
        Assert.isNotNull(iResponse);
        URL uRL2 = request.getResourceUrl();
        URL uRL3 = null;
        try {
            uRL3 = new URL(uRL2.getProtocol(), uRL2.getHost(), uRL2.getPort(), "/");
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        String string = this.authenticatorStore.getProtectionSpace(uRL2);
        if (string == null) {
            return false;
        }
        Map map = null;
        String string2 = null;
        int n = 0;
        while (n < authenticationSchemes.length) {
            string2 = authenticationSchemes[n];
            map = this.authenticatorStore.getAuthenticationInfo(uRL3, string, string2);
            if (map != null) break;
            ++n;
        }
        if (map == null) {
            return false;
        }
        AuthorizationAuthority authorizationAuthority = this.getAuthorizationAuthority(string2);
        if (authorizationAuthority == null) {
            return false;
        }
        return authorizationAuthority.confirmResponse(request, iResponse, uRL);
    }

    protected boolean confirmResponse(Request request, IResponse iResponse, URL uRL) {
        Assert.isNotNull(request);
        Assert.isNotNull(iResponse);
        return false;
    }

    protected Map getAuthenticationInfo(AuthenticateChallenge authenticateChallenge, Map map, URL uRL, URL uRL2) {
        Assert.isNotNull(authenticateChallenge);
        Assert.isNotNull(uRL);
        Assert.isNotNull(uRL2);
        return null;
    }

    protected String getAuthorization(Request request, Map map, URL uRL, URL uRL2, URL uRL3) {
        Assert.isNotNull(request);
        Assert.isNotNull(map);
        Assert.isNotNull(uRL);
        Assert.isNotNull(uRL2);
        return null;
    }

    private AuthorizationAuthority getAuthorizationAuthority(String string) {
        try {
            string = String.valueOf(Character.toUpperCase(string.charAt(0))) + string.substring(1).toLowerCase();
            String string2 = "org.eclipse.webdav.internal.authentication";
            String string3 = String.valueOf(string) + "Authority";
            Class<?> clazz = Class.forName(String.valueOf(string2) + "." + string3);
            Constructor<?> constructor = clazz.getConstructor(IAuthenticator.class);
            return (AuthorizationAuthority)constructor.newInstance(this.authenticatorStore);
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {}
        return null;
    }

    protected String md5(String string) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = messageDigest.digest(string.getBytes("UTF8"));
        return HexConverter.toHex(byArray);
    }

    protected String md5(Request request) throws NoSuchAlgorithmException, IOException {
        DigestOutputStream digestOutputStream = new DigestOutputStream("MD5");
        request.write(digestOutputStream);
        String string = HexConverter.toHex(digestOutputStream.digest());
        digestOutputStream.close();
        return string;
    }

    protected String unquote(String string) {
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }
}

