/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.authentication;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.http.client.IAuthenticator;
import org.eclipse.webdav.http.client.Request;
import org.eclipse.webdav.internal.authentication.AuthenticateChallenge;
import org.eclipse.webdav.internal.authentication.AuthenticationInfo;
import org.eclipse.webdav.internal.authentication.AuthorizationAuthority;
import org.eclipse.webdav.internal.authentication.HexConverter;
import org.eclipse.webdav.internal.authentication.Parser;
import org.eclipse.webdav.internal.authentication.ParserException;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class DigestAuthority
extends AuthorizationAuthority {
    public DigestAuthority(IAuthenticator iAuthenticator) {
        super(iAuthenticator);
    }

    protected boolean confirmResponse(Request request, IResponse iResponse, URL uRL) {
        Assert.isNotNull(request);
        Assert.isNotNull(iResponse);
        String string = iResponse.getContext().get("Authentication-Info");
        if (string == null) {
            return false;
        }
        AuthenticationInfo authenticationInfo = null;
        try {
            authenticationInfo = new AuthenticationInfo(string);
        }
        catch (ParserException parserException) {
            return false;
        }
        String string2 = authenticationInfo.getNextNonce();
        String string3 = authenticationInfo.getMessageQop();
        String string4 = authenticationInfo.getResponseAuth();
        String string5 = authenticationInfo.getCNonce();
        String string6 = authenticationInfo.getNonceCount();
        URL uRL2 = request.getResourceUrl();
        URL uRL3 = null;
        try {
            uRL3 = new URL(uRL2.getProtocol(), uRL2.getHost(), uRL2.getPort(), "/");
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        String string7 = this.authenticatorStore.getProtectionSpace(uRL2);
        if (string7 == null) {
            return false;
        }
        Map map = this.authenticatorStore.getAuthenticationInfo(uRL3, string7, "Digest");
        if (map == null) {
            return false;
        }
        String string8 = (String)map.get("username");
        String string9 = (String)map.get("password");
        String string10 = (String)map.get("algorithm");
        String string11 = (String)map.get("nonce");
        String string12 = (String)map.get("nc");
        String string13 = (String)map.get("cnonce");
        if (string8 == null || string9 == null || string11 == null) {
            return false;
        }
        if (string5 != null && !string5.equals(string13)) {
            return false;
        }
        if (string6 != null && !string6.equals(string12)) {
            return false;
        }
        if (string4 != null) {
            try {
                String string14;
                String string15 = uRL2.toString();
                if (uRL == null) {
                    string15 = uRL2.getFile();
                    string14 = uRL2.getRef();
                    if (string14 != null) {
                        string15 = String.valueOf(string15) + "#" + string14;
                    }
                }
                if (!string4.equals(string14 = this.response(request, string7, string8, string9, string10, string3, string11, string6, string5, request.getMethod(), string15))) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        map.put("nonce", string2);
        return true;
    }

    private String credentials(Request request, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) throws Exception {
        String string12;
        Assert.isNotNull(request);
        Assert.isNotNull(string);
        Assert.isNotNull(string2);
        Assert.isNotNull(string3);
        Assert.isNotNull(string6);
        Assert.isNotNull(string10);
        Assert.isNotNull(string11);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Digest username=\"");
        stringBuffer.append(string2);
        stringBuffer.append("\"");
        stringBuffer.append(", realm=");
        stringBuffer.append(string);
        if (string5 != null) {
            stringBuffer.append(", qop=\"");
            stringBuffer.append(string5);
            stringBuffer.append("\"");
        }
        if (string4 != null) {
            stringBuffer.append(", algorithm=");
            stringBuffer.append(string4);
        }
        stringBuffer.append(", uri=\"");
        stringBuffer.append(string11);
        stringBuffer.append("\"");
        stringBuffer.append(", nonce=");
        stringBuffer.append(string6);
        if (string7 != null) {
            stringBuffer.append(", nc=");
            stringBuffer.append(string7);
        }
        if (string9 != null) {
            stringBuffer.append(", cnonce=\"");
            stringBuffer.append(string9);
            stringBuffer.append("\"");
        }
        if (string8 != null) {
            stringBuffer.append(", opaque=");
            stringBuffer.append(string8);
        }
        if ((string12 = this.response(request, string, string2, string3, string4, string5, string6, string7, string9, string10, string11)) == null) {
            return null;
        }
        stringBuffer.append(", response=\"");
        stringBuffer.append(string12);
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    protected Map getAuthenticationInfo(AuthenticateChallenge authenticateChallenge, Map map, URL uRL, URL uRL2) {
        String string;
        String string2;
        String string3;
        Object object;
        Assert.isNotNull(authenticateChallenge);
        Assert.isNotNull(uRL);
        Assert.isNotNull(uRL2);
        Hashtable hashtable = new Hashtable(5);
        String string4 = authenticateChallenge.get("stale");
        if (map == null || string4 == null || !Boolean.valueOf(string4).booleanValue()) {
            object = this.authenticatorStore.requestAuthenticationInfo(uRL2, authenticateChallenge.getRealm(), authenticateChallenge.getAuthScheme());
            if (object == null) {
                return null;
            }
            hashtable.put("username", object.get("username"));
            hashtable.put("password", object.get("password"));
        } else {
            hashtable.put("username", map.get("username"));
            hashtable.put("password", map.get("password"));
        }
        object = authenticateChallenge.getRealm();
        String string5 = authenticateChallenge.get("domain");
        boolean bl = true;
        if (string5 != null && string5.charAt(0) == '\"' && string5.charAt(string5.length() - 1) == '\"') {
            int n = 1;
            boolean bl2 = false;
            int n2 = 1;
            while (n2 < string5.length()) {
                if (Character.isWhitespace(string5.charAt(n2)) || n2 == string5.length() - 1) {
                    if (!bl2) {
                        bl2 = true;
                        string3 = string5.substring(n, n2);
                        URL uRL3 = null;
                        try {
                            uRL3 = new URL(string3);
                        }
                        catch (MalformedURLException malformedURLException) {
                            try {
                                uRL3 = new URL(uRL, string3);
                            }
                            catch (MalformedURLException malformedURLException2) {}
                        }
                        if (uRL3 != null) {
                            this.authenticatorStore.addProtectionSpace(uRL3, (String)object);
                            bl = false;
                        }
                    }
                } else if (bl2) {
                    bl2 = false;
                    n = n2;
                }
                ++n2;
            }
        }
        if (bl) {
            this.authenticatorStore.addProtectionSpace(uRL, (String)object);
        }
        if ((string2 = authenticateChallenge.get("nonce")) == null) {
            return null;
        }
        hashtable.put("nonce", string2);
        String string6 = authenticateChallenge.get("opaque");
        if (string6 != null) {
            hashtable.put("opaque", string6);
        }
        if ((string = authenticateChallenge.get("algorithm")) != null) {
            hashtable.put("algorithm", string);
        }
        if ((string3 = authenticateChallenge.get("qop")) != null && string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
            boolean bl3 = false;
            boolean bl4 = false;
            try {
                String string7 = null;
                boolean bl5 = true;
                Parser parser = new Parser(string3.substring(1, string3.length() - 1));
                while (parser.pos < parser.s.length()) {
                    if (bl5) {
                        parser.skipWhiteSpace();
                        bl5 = false;
                    } else {
                        parser.match(',');
                        parser.skipWhiteSpace();
                    }
                    string7 = parser.nextToken();
                    if (string7.equalsIgnoreCase("auth")) {
                        bl3 = true;
                    } else if (string7.equalsIgnoreCase("auth-int")) {
                        bl4 = true;
                    }
                    parser.skipWhiteSpace();
                }
            }
            catch (ParserException parserException) {}
            if (bl4) {
                hashtable.put("qop", "auth-int");
            } else if (bl3) {
                hashtable.put("qop", "auth");
            }
        }
        return hashtable;
    }

    protected String getAuthorization(Request request, Map map, URL uRL, URL uRL2, URL uRL3) {
        String string;
        Object object;
        Serializable serializable;
        Assert.isNotNull(request);
        Assert.isNotNull(map);
        Assert.isNotNull(uRL);
        Assert.isNotNull(uRL2);
        String string2 = (String)map.get("username");
        String string3 = (String)map.get("password");
        String string4 = (String)map.get("algorithm");
        String string5 = (String)map.get("qop");
        String string6 = (String)map.get("nonce");
        String string7 = (String)map.get("nc");
        String string8 = (String)map.get("opaque");
        String string9 = null;
        if (string2 == null || string3 == null || string6 == null) {
            return null;
        }
        if (string5 != null) {
            if (string7 == null) {
                string7 = "00000001";
            } else {
                int n = Integer.parseInt(string7, 16) + 1;
                string7 = HexConverter.toHex(new int[]{n});
            }
            map.put("nc", string7);
            long l = new Date().getTime();
            serializable = new SecureRandom();
            ((SecureRandom)serializable).setSeed(l);
            object = new byte[16];
            ((SecureRandom)serializable).nextBytes((byte[])object);
            string9 = HexConverter.toHex((byte[])object);
            map.put("cnonce", string9);
        }
        if ((string = this.authenticatorStore.getProtectionSpace(uRL2)) == null) {
            return null;
        }
        String string10 = request.getMethod();
        serializable = request.getResourceUrl();
        object = ((URL)serializable).toString();
        if (uRL3 != null) {
            object = ((URL)serializable).getFile();
            String string11 = ((URL)serializable).getRef();
            if (string11 != null) {
                object = String.valueOf(object) + "#" + string11;
            }
        }
        try {
            return this.credentials(request, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, (String)object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String ha1(String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        Assert.isNotNull(string);
        Assert.isNotNull(string2);
        Assert.isNotNull(string3);
        Assert.isNotNull(string5);
        String string7 = this.md5(String.valueOf(this.unquote(string2)) + ":" + this.unquote(string) + ":" + string3);
        if (string4 != null && !string4.equalsIgnoreCase("MD5")) {
            if (string4.equalsIgnoreCase("MD5-sess")) {
                if (string6 == null) {
                    return null;
                }
                string7 = this.md5(String.valueOf(string7) + ":" + this.unquote(string5) + ":" + this.unquote(string6));
            } else {
                throw new Exception(Policy.bind("exception.unregognizedAlgo", string4));
            }
        }
        return string7;
    }

    private String ha2(Request request, String string, String string2, String string3) throws Exception {
        Assert.isNotNull(request);
        Assert.isNotNull(string2);
        Assert.isNotNull(string3);
        String string4 = null;
        if (string == null || string.equalsIgnoreCase("auth")) {
            string4 = this.md5(String.valueOf(string2 == null ? "" : string2) + ":" + string3);
        } else if (string.equalsIgnoreCase("auth-int")) {
            string4 = this.md5(String.valueOf(string2 == null ? "" : string2) + ":" + string3 + this.md5(request));
        } else {
            throw new Exception(Policy.bind("exception.unregognizedQop", string));
        }
        return string4;
    }

    private String response(Request request, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws Exception {
        Assert.isNotNull(request);
        Assert.isNotNull(string);
        Assert.isNotNull(string2);
        Assert.isNotNull(string3);
        Assert.isNotNull(string6);
        Assert.isNotNull(string9);
        Assert.isNotNull(string10);
        String string11 = this.ha1(string, string2, string3, string4, string6, string8);
        if (string11 == null) {
            return null;
        }
        String string12 = this.ha2(request, string5, string9, string10);
        if (string12 == null) {
            return null;
        }
        if (string5 == null) {
            return this.md5(String.valueOf(string11) + ":" + this.unquote(string6) + ":" + string12);
        }
        if (string7 == null || string8 == null || string5 == null) {
            return null;
        }
        return this.md5(String.valueOf(string11) + ":" + this.unquote(string6) + ":" + string7 + ":" + this.unquote(string8) + ":" + this.unquote(string5) + ":" + string12);
    }
}

