/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.authentication;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestOutputStream
extends FilterOutputStream {
    private MessageDigest messageDigest = null;
    private byte[] digest = null;

    public DigestOutputStream(OutputStream outputStream, String string) throws NoSuchAlgorithmException {
        super(outputStream);
        this.messageDigest = MessageDigest.getInstance(string);
    }

    public DigestOutputStream(String string) throws NoSuchAlgorithmException {
        this(new NullOutputStream(), string);
    }

    public byte[] digest() {
        if (this.digest == null) {
            this.digest = this.messageDigest.digest();
        }
        return this.digest;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.messageDigest.update(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.out.write(n);
        this.messageDigest.update((byte)n);
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int n) throws IOException {
        }
    }
}

