/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.webdav.internal.kernel.ConditionTerm;
import org.eclipse.webdav.internal.kernel.Policy;
import org.eclipse.webdav.internal.kernel.WebDAVException;

public class Condition {
    private String uri = null;
    private Vector conditionTerms = new Vector();

    public Condition() {
    }

    public Condition(String string) {
        this.uri = string;
    }

    public void addConditionTerm(ConditionTerm conditionTerm) throws WebDAVException {
        this.conditionTerms.addElement(conditionTerm);
    }

    public boolean contains(ConditionTerm conditionTerm) {
        boolean bl = false;
        Enumeration enumeration = this.getConditionTerms();
        while (!bl && enumeration.hasMoreElements()) {
            ConditionTerm conditionTerm2 = (ConditionTerm)enumeration.nextElement();
            bl = conditionTerm.matches(conditionTerm2);
        }
        return bl;
    }

    public static Condition create(StreamTokenizer streamTokenizer) throws WebDAVException {
        Condition condition;
        block8: {
            condition = new Condition();
            try {
                int n = streamTokenizer.ttype;
                if (n == 60) {
                    n = streamTokenizer.nextToken();
                    if (n != -3) {
                        throw new WebDAVException(400, Policy.bind("error.parseMissingResource"));
                    }
                    condition.setResourceURI(streamTokenizer.sval);
                    n = streamTokenizer.nextToken();
                    if (n == 62) {
                        n = streamTokenizer.nextToken();
                    } else {
                        throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(n), ">"));
                    }
                }
                if (n == 40) {
                    while (n == 40) {
                        condition.addConditionTerm(ConditionTerm.create(streamTokenizer));
                        n = streamTokenizer.ttype;
                    }
                    break block8;
                }
                throw new WebDAVException(400, Policy.bind("error.parseMissingStart", String.valueOf(n)));
            }
            catch (IOException iOException) {}
        }
        return condition;
    }

    public static Condition create(String string) throws WebDAVException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.wordChars(33, 47);
        streamTokenizer.wordChars(58, 64);
        streamTokenizer.ordinaryChar(40);
        streamTokenizer.ordinaryChar(41);
        streamTokenizer.ordinaryChar(60);
        streamTokenizer.ordinaryChar(62);
        streamTokenizer.ordinaryChar(91);
        streamTokenizer.ordinaryChar(93);
        streamTokenizer.quoteChar(34);
        Condition condition = null;
        try {
            int n = streamTokenizer.nextToken();
            condition = Condition.create(streamTokenizer);
            n = streamTokenizer.ttype;
            if (n != -1) {
                throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(n), "EOF"));
            }
        }
        catch (IOException iOException) {}
        return condition;
    }

    public Enumeration getConditionTerms() {
        return this.conditionTerms.elements();
    }

    public String getResourceURI() {
        return this.uri;
    }

    public boolean matches(Condition condition) {
        return false;
    }

    public void setResourceURI(String string) {
        this.uri = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getResourceURI() != null) {
            stringBuffer.append('<');
            stringBuffer.append(this.getResourceURI());
            stringBuffer.append("> ");
        }
        Enumeration enumeration = this.getConditionTerms();
        while (enumeration.hasMoreElements()) {
            ConditionTerm conditionTerm = (ConditionTerm)enumeration.nextElement();
            stringBuffer.append(conditionTerm.toString());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

