/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.io.IOException;
import java.io.StreamTokenizer;
import org.eclipse.webdav.internal.kernel.EntityTag;
import org.eclipse.webdav.internal.kernel.Policy;
import org.eclipse.webdav.internal.kernel.StateToken;
import org.eclipse.webdav.internal.kernel.WebDAVException;

public abstract class ConditionFactor {
    private boolean not = false;

    public static ConditionFactor create(StreamTokenizer streamTokenizer) throws WebDAVException {
        boolean bl = false;
        ConditionFactor conditionFactor = null;
        try {
            int n = streamTokenizer.ttype;
            if (n == -3) {
                if (!streamTokenizer.sval.equalsIgnoreCase("Not")) {
                    throw new WebDAVException(400, Policy.bind("error.parseMissingNot"));
                }
                bl = true;
                n = streamTokenizer.nextToken();
            }
            switch (n) {
                case 60: {
                    conditionFactor = StateToken.create(streamTokenizer);
                    break;
                }
                case 91: {
                    conditionFactor = EntityTag.create(streamTokenizer);
                    break;
                }
                default: {
                    throw new WebDAVException(400, Policy.bind("error.parseMissingOpen", String.valueOf(n)));
                }
            }
        }
        catch (IOException iOException) {}
        conditionFactor.setNot(bl);
        return conditionFactor;
    }

    public boolean not() {
        return this.not;
    }

    public void setNot(boolean bl) {
        this.not = bl;
    }

    public abstract String toString();
}

