/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.webdav.internal.kernel.ConditionFactor;
import org.eclipse.webdav.internal.kernel.Policy;
import org.eclipse.webdav.internal.kernel.WebDAVException;

public class ConditionTerm {
    private Vector conditionFactors = new Vector();

    public void addConditionFactor(ConditionFactor conditionFactor) throws WebDAVException {
        if (this.conditionFactors.contains(conditionFactor)) {
            throw new WebDAVException(400, Policy.bind("error.parseDuplicateEntry"));
        }
        this.conditionFactors.addElement(conditionFactor);
    }

    public boolean contains(ConditionFactor conditionFactor) {
        return this.conditionFactors.contains(conditionFactor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConditionTerm create(StreamTokenizer streamTokenizer) throws WebDAVException {
        ConditionTerm conditionTerm = new ConditionTerm();
        try {
            int n = streamTokenizer.ttype;
            if (n != 40) {
                throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(n), "("));
            }
            n = streamTokenizer.nextToken();
            while (true) {
                if (n != -3 && n != 60 && n != 91) {
                    if (n != 41) {
                        throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(n), ")"));
                    }
                    n = streamTokenizer.nextToken();
                    break;
                }
                conditionTerm.addConditionFactor(ConditionFactor.create(streamTokenizer));
                n = streamTokenizer.ttype;
            }
        }
        catch (IOException iOException) {}
        if (!conditionTerm.getConditionFactors().hasMoreElements()) {
            throw new WebDAVException(400, Policy.bind("error.parseMissingStateOrEntity"));
        }
        return conditionTerm;
    }

    public Enumeration getConditionFactors() {
        return this.conditionFactors.elements();
    }

    public boolean matches(ConditionTerm conditionTerm) {
        int n = 0;
        boolean bl = true;
        Enumeration enumeration = this.getConditionFactors();
        while (bl && enumeration.hasMoreElements()) {
            ConditionFactor conditionFactor = (ConditionFactor)enumeration.nextElement();
            if (conditionFactor.not()) {
                bl = !conditionTerm.contains(conditionFactor);
                continue;
            }
            bl = conditionTerm.contains(conditionFactor);
            ++n;
        }
        bl = bl && n == conditionTerm.numberOfFactors();
        return bl;
    }

    public int numberOfFactors() {
        return this.conditionFactors.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Enumeration enumeration = this.getConditionFactors();
        while (enumeration.hasMoreElements()) {
            ConditionFactor conditionFactor = (ConditionFactor)enumeration.nextElement();
            stringBuffer.append(conditionFactor.toString());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(' ');
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

