/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import org.eclipse.webdav.internal.kernel.Policy;

public class DAVRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private Throwable fWrappedException = null;
    private int fErrorCode = 0;

    public DAVRuntimeException(int n, String string) {
        super(string);
        this.setErrorCode(n);
    }

    public DAVRuntimeException(String string) {
        super(string);
    }

    public DAVRuntimeException(Throwable throwable) {
        if (throwable instanceof DAVRuntimeException) {
            this.setWrappedException(((DAVRuntimeException)throwable).getWrappedException());
        } else {
            this.setWrappedException(throwable);
        }
    }

    public DAVRuntimeException(Throwable throwable, String string) {
        super(String.valueOf(string) + "\n " + Policy.bind("label.exceptionMessage") + throwable.getMessage());
        this.setWrappedException(throwable);
    }

    public int getErrorCode() {
        if (this.getWrappedException() != null && this.getWrappedException() instanceof DAVRuntimeException) {
            return ((DAVRuntimeException)this.getWrappedException()).getErrorCode();
        }
        return this.fErrorCode;
    }

    public Throwable getWrappedException() {
        return this.fWrappedException;
    }

    public void printStackTrace() {
        Throwable throwable = this.getWrappedException();
        if (throwable != null) {
            throwable.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    protected void setErrorCode(int n) {
        this.fErrorCode = n;
    }

    protected void setWrappedException(Throwable throwable) {
        this.fWrappedException = throwable;
    }
}

