/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.webdav.internal.kernel.IDocumentMarshaler;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentMarshaler
implements IDocumentMarshaler {
    public Document parse(Reader reader) throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(new InputSource(reader));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
    }

    public void print(Document document, Writer writer, String string) throws IOException {
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IOException(transformerConfigurationException.getMessageAndLocation());
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new IOException(transformerFactoryConfigurationError.getMessage());
        }
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(writer);
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new IOException(transformerException.getMessageAndLocation());
        }
    }
}

