/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.util.Enumeration;
import org.eclipse.webdav.dom.QualifiedName;
import org.eclipse.webdav.internal.kernel.DocumentFactory;
import org.eclipse.webdav.internal.kernel.Policy;
import org.eclipse.webdav.internal.kernel.WebDAVConstants;
import org.eclipse.webdav.internal.kernel.utils.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ElementHelper
implements WebDAVConstants {
    protected Document nodeFactory;
    protected static final String DAV_PREFIX = "D";
    protected static final String NS_SEPARATOR = ":";
    protected static final String DAV_NS_ATTRIB = "xmlns:D";

    public ElementHelper() {
        DocumentFactory documentFactory = new DocumentFactory();
        this.nodeFactory = documentFactory.newDocument();
    }

    public String extractText(Element element) {
        NodeList nodeList = element.getChildNodes();
        Assert.isTrue(nodeList.getLength() == 1, Policy.bind("error.requireElementWithSingleChild"));
        Node node = nodeList.item(0);
        Assert.isTrue(node instanceof Text, Policy.bind("error.extractFromElementWithoutText"));
        return ((Text)node).getData();
    }

    public Element newDAVElement(QualifiedName qualifiedName) {
        Assert.isTrue(qualifiedName.getQualifier().equals("DAV:"), Policy.bind("error.davElementsNeedQualifier"));
        Element element = this.nodeFactory.createElement("D:" + qualifiedName.getLocalName());
        element.setAttribute(DAV_NS_ATTRIB, "DAV:");
        return element;
    }

    public Element newDAVElementSet(QualifiedName qualifiedName, QualifiedName qualifiedName2, Enumeration enumeration) {
        Element element = this.newDAVElement(qualifiedName);
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Element element2 = this.newDAVTextElement(qualifiedName2, string);
            element.appendChild(element2);
        }
        return element;
    }

    public Element newDAVProperty(QualifiedName qualifiedName, String string) {
        Element element = this.newDAVElement(qualifiedName);
        element.appendChild(this.nodeFactory.createTextNode(string));
        return element;
    }

    public Element newDAVProperty(QualifiedName qualifiedName, Element element) {
        Element element2 = this.newDAVElement(qualifiedName);
        element2.appendChild(element);
        return element2;
    }

    public Element newDAVTextElement(QualifiedName qualifiedName, String string) {
        Element element = this.newDAVElement(qualifiedName);
        element.appendChild(this.nodeFactory.createTextNode(string));
        return element;
    }

    public Element newTextElement(String string, String string2) {
        Element element = this.nodeFactory.createElement(string);
        element.appendChild(this.nodeFactory.createTextNode(string2));
        return element;
    }
}

