/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Date;
import org.eclipse.webdav.internal.kernel.ConditionFactor;
import org.eclipse.webdav.internal.kernel.Policy;
import org.eclipse.webdav.internal.kernel.WebDAVException;

public class EntityTag
extends ConditionFactor {
    private static int bcnt = 0;
    private static String basetime = Long.toHexString(new Date().getTime());
    private String eTag = null;
    private boolean weak = false;

    private EntityTag() {
    }

    public EntityTag(String string) {
        this.eTag = string;
    }

    public static ConditionFactor create(StreamTokenizer streamTokenizer) throws WebDAVException {
        EntityTag entityTag = new EntityTag();
        try {
            int n = streamTokenizer.ttype;
            if (n != 91) {
                throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(n), "["));
            }
            n = streamTokenizer.nextToken();
            if (n != 34) {
                throw new WebDAVException(400, Policy.bind("error.parseMissingQuotedString", String.valueOf(n)));
            }
            entityTag.setETag(streamTokenizer.sval);
            n = streamTokenizer.nextToken();
            if (n != 93) {
                throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(n), "]"));
            }
            n = streamTokenizer.nextToken();
        }
        catch (IOException iOException) {}
        return entityTag;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof EntityTag && this.getETag().equals(((EntityTag)object).getETag());
    }

    public static EntityTag generateEntityTag() {
        String string = String.valueOf(basetime) + ":" + Integer.toHexString(Thread.currentThread().hashCode());
        string = String.valueOf(string) + ":" + ++bcnt;
        return new EntityTag(string);
    }

    public String getETag() {
        return this.eTag;
    }

    public boolean isWeak() {
        return this.weak;
    }

    public void setETag(String string) {
        this.eTag = string;
    }

    public void setWeak(boolean bl) {
        this.weak = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.not()) {
            stringBuffer.append("Not ");
        }
        if (this.isWeak()) {
            stringBuffer.append("W/");
        }
        stringBuffer.append("[\"");
        stringBuffer.append(this.getETag());
        stringBuffer.append("\"]");
        return stringBuffer.toString();
    }
}

