/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import org.eclipse.webdav.ILocator;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class Locator
implements ILocator {
    protected String resourceURL;
    protected String label;
    protected boolean isStable;

    public Locator(String string, String string2) {
        Assert.isLegal(string != null);
        this.resourceURL = string;
        this.label = string2;
        this.isStable = false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ILocator)) {
            return false;
        }
        ILocator iLocator = (ILocator)object;
        if (!this.resourceURL.equals(iLocator.getResourceURL())) {
            return false;
        }
        if (this.label == null) {
            return iLocator.getLabel() == null;
        }
        return this.label.equals(iLocator.getLabel());
    }

    public int hashCode() {
        return this.resourceURL.hashCode();
    }

    public String getLabel() {
        return this.label;
    }

    public String getResourceURL() {
        return this.resourceURL;
    }

    public boolean isStable() {
        return this.isStable;
    }

    public void markStable() {
        Assert.isTrue(this.label == null);
        this.isStable = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[Locator ");
        stringBuffer.append(this.resourceURL);
        if (this.label != null) {
            stringBuffer.append("\n  label: ");
            stringBuffer.append(this.label);
        }
        if (this.isStable) {
            stringBuffer.append("\n  stable");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

