/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.webdav.internal.kernel.Condition;
import org.eclipse.webdav.internal.kernel.ConditionTerm;
import org.eclipse.webdav.internal.kernel.Policy;
import org.eclipse.webdav.internal.kernel.StateToken;
import org.eclipse.webdav.internal.kernel.WebDAVException;

public class Precondition {
    private Vector conditions = new Vector();

    public Precondition() {
    }

    public Precondition(String string) throws WebDAVException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.wordChars(33, 47);
        streamTokenizer.wordChars(58, 64);
        streamTokenizer.ordinaryChar(40);
        streamTokenizer.ordinaryChar(41);
        streamTokenizer.ordinaryChar(60);
        streamTokenizer.ordinaryChar(62);
        streamTokenizer.ordinaryChar(91);
        streamTokenizer.ordinaryChar(93);
        streamTokenizer.quoteChar(34);
        int n = 0;
        try {
            n = streamTokenizer.nextToken();
            switch (n) {
                case 60: {
                    while (n == 60) {
                        this.addCondition(Condition.create(streamTokenizer));
                        n = streamTokenizer.ttype;
                    }
                    break;
                }
                case 40: {
                    while (n == 40) {
                        this.addCondition(Condition.create(streamTokenizer));
                        n = streamTokenizer.ttype;
                    }
                    break;
                }
            }
            if (n != -1) {
                throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(n), "EOF"));
            }
            if (!this.getConditions().hasMoreElements()) {
                throw new WebDAVException(400, Policy.bind("error.parseEmptyList", string));
            }
        }
        catch (IOException iOException) {}
    }

    public void addCondition(Condition condition) throws WebDAVException {
        Enumeration enumeration = this.getConditions();
        if (condition.getResourceURI() != null) {
            while (enumeration.hasMoreElements()) {
                Condition condition2 = (Condition)enumeration.nextElement();
                if (condition2.getResourceURI() == null || !condition2.getResourceURI().equals(condition.getResourceURI())) continue;
                throw new WebDAVException(400, Policy.bind("error.parseMultipleSpecification", condition.getResourceURI()));
            }
        }
        this.conditions.addElement(condition);
    }

    public void addStateTokenCondition(String string, String string2) throws WebDAVException {
        Condition condition = new Condition(string);
        ConditionTerm conditionTerm = new ConditionTerm();
        conditionTerm.addConditionFactor(new StateToken(string2));
        condition.addConditionTerm(conditionTerm);
        this.addCondition(condition);
    }

    public static Precondition create(String string) throws WebDAVException {
        return new Precondition(string);
    }

    public Enumeration getConditions() {
        return this.conditions.elements();
    }

    public boolean matches(Condition condition) {
        boolean bl = false;
        Enumeration enumeration = this.getConditions();
        while (!bl && enumeration.hasMoreElements()) {
            Condition condition2 = (Condition)enumeration.nextElement();
            bl = condition2.matches(condition);
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getConditions();
        while (enumeration.hasMoreElements()) {
            Condition condition = (Condition)enumeration.nextElement();
            stringBuffer.append(condition.toString());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

