/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.internal.kernel.DocumentMarshaler;
import org.eclipse.webdav.internal.kernel.Message;
import org.eclipse.webdav.internal.kernel.Policy;
import org.eclipse.webdav.internal.kernel.Status;
import org.eclipse.webdav.internal.kernel.utils.Assert;
import org.w3c.dom.Document;

public class Response
extends Message
implements IResponse {
    protected Status status;

    public Response(Status status, IContext iContext, InputStream inputStream) {
        this.status = status;
        this.context = iContext;
        this.body = inputStream;
    }

    public Response(Status status, IContext iContext, Document document) {
        this.status = status;
        this.context = iContext;
        this.body = document;
    }

    public void close() throws IOException {
        if (!this.hasDocumentBody()) {
            this.getInputStream().close();
        }
    }

    public Document getDocumentBody() throws IOException {
        Assert.isTrue(this.hasDocumentBody(), Policy.bind("error.receiverMissingBody"));
        return (Document)this.body;
    }

    public InputStream getInputStream() {
        Assert.isTrue(!this.hasDocumentBody(), Policy.bind("error.receiverHasBody"));
        return (InputStream)this.body;
    }

    public int getStatusCode() {
        return this.status.getCode();
    }

    public String getStatusMessage() {
        return this.status.getMessage();
    }

    public boolean hasDocumentBody() {
        return this.body instanceof Document;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.status.toHTTPString());
        stringBuffer.append('\n');
        stringBuffer.append(this.context.toString());
        stringBuffer.append('\n');
        try {
            if (this.hasDocumentBody()) {
                DocumentMarshaler documentMarshaler = new DocumentMarshaler();
                StringWriter stringWriter = new StringWriter();
                documentMarshaler.print(this.getDocumentBody(), stringWriter, "UTF-8");
                stringBuffer.append(((Object)stringWriter).toString());
            } else {
                stringBuffer.append("<<" + Policy.bind("label.bytes", String.valueOf(this.getInputStream().available())) + ">>");
            }
        }
        catch (IOException iOException) {
            stringBuffer.append("<<" + Policy.bind("exception.dumping", iOException.getMessage()) + ">>");
        }
        return stringBuffer.toString();
    }
}

