/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.io.IOException;
import java.io.StreamTokenizer;
import org.eclipse.webdav.internal.kernel.ConditionFactor;
import org.eclipse.webdav.internal.kernel.Policy;
import org.eclipse.webdav.internal.kernel.WebDAVException;

public class StateToken
extends ConditionFactor {
    private String uri = null;

    private StateToken() {
    }

    public StateToken(String string) {
        this.uri = string;
    }

    public static ConditionFactor create(StreamTokenizer streamTokenizer) throws WebDAVException {
        StateToken stateToken = new StateToken();
        try {
            int n = streamTokenizer.ttype;
            if (n != 60) {
                throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(n), "<"));
            }
            n = streamTokenizer.nextToken();
            if (n != -3) {
                throw new WebDAVException(400, Policy.bind("error.parseMissingURI", String.valueOf(n)));
            }
            stateToken.setURI(streamTokenizer.sval);
            n = streamTokenizer.nextToken();
            if (n != 62) {
                throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(n), ">"));
            }
            n = streamTokenizer.nextToken();
        }
        catch (IOException iOException) {}
        return stateToken;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof StateToken && this.getURI().equals(((StateToken)object).getURI());
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String string) {
        this.uri = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.not()) {
            stringBuffer.append("Not ");
        }
        stringBuffer.append('<');
        stringBuffer.append(this.getURI());
        stringBuffer.append('>');
        return stringBuffer.toString();
    }
}

