/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import org.w3c.dom.Document;

public class Status
implements Cloneable {
    protected int code;
    protected String message;
    protected Document extendedStatus;
    public static final Status CONTINUE = new Status(100, "Continue");
    public static final Status SWITCHING_PROTOCOLS = new Status(101, "Switching Protocols");
    public static final Status PROCESSING = new Status(102, "Processing");
    public static final Status OK = new Status(200, "OK");
    public static final Status CREATED = new Status(201, "Created");
    public static final Status ACCEPTED = new Status(202, "Accepted");
    public static final Status NON_AUTHORITATIVE_INFORMATION = new Status(203, "Non Authoritative Information");
    public static final Status NO_CONTENT = new Status(204, "No Content");
    public static final Status RESET_CONTENT = new Status(205, "Reset Content");
    public static final Status PARTIAL_CONTENT = new Status(206, "Partial Content");
    public static final Status MULTI_STATUS = new Status(207, "Multi-Status");
    public static final Status MULTIPLE_CHOICES = new Status(300, "Multiple Choices");
    public static final Status MOVED_PERMANENTLY = new Status(301, "Moved Permanently");
    public static final Status MOVED_TEMPORARILY = new Status(302, "Moved Temporarily");
    public static final Status SEE_OTHER = new Status(303, "See Other");
    public static final Status NOT_MODIFIED = new Status(304, "Not Modified");
    public static final Status USE_PROXY = new Status(305, "Use Proxy");
    public static final Status BAD_REQUEST = new Status(400, "Bad Request");
    public static final Status UNAUTHORIZED = new Status(401, "Unauthorized");
    public static final Status PAYMENT_REQUIRED = new Status(402, "Payment Required");
    public static final Status FORBIDDEN = new Status(403, "Forbidden");
    public static final Status NOT_FOUND = new Status(404, "Not Found");
    public static final Status METHOD_NOT_ALLOWED = new Status(405, "Method Not Allowed");
    public static final Status NOT_ACCEPTABLE = new Status(406, "Not Acceptable");
    public static final Status PROXY_AUTHENTICATION_REQUIRED = new Status(407, "Proxy Authentication Required");
    public static final Status REQUEST_TIMEOUT = new Status(408, "Request Timeout");
    public static final Status CONFLICT = new Status(409, "Conflict");
    public static final Status GONE = new Status(410, "Gone");
    public static final Status LENGTH_REQUIRED = new Status(411, "Length Required");
    public static final Status PRECONDITION_FAILED = new Status(412, "Precondition Failed");
    public static final Status REQUEST_TOO_LONG = new Status(413, "Request Too Long");
    public static final Status REQUEST_URI_TOO_LONG = new Status(414, "Request URI Too Long");
    public static final Status UNSUPPORTED_MEDIA_TYPE = new Status(415, "Unsupported Media Type");
    public static final Status UNPROCESSABLE_ENTITY = new Status(422, "Unprocessable Entity");
    public static final Status LOCKED = new Status(423, "Locked");
    public static final Status FAILED_DEPENDENCY = new Status(424, "Failed Dependency");
    public static final Status INSUFFICIENT_SPACE_ON_RESOURCE = new Status(425, "Insufficient Space on Resource");
    public static final Status INTERNAL_SERVER_ERROR = new Status(500, "Internal Server Error");
    public static final Status NOT_IMPLEMENTED = new Status(501, "Not Implemented");
    public static final Status BAD_GATEWAY = new Status(502, "Bad Gateway");
    public static final Status SERVICE_UNAVAILABLE = new Status(503, "Service Unavailable");
    public static final Status GATEWAY_TIMEOUT = new Status(504, "Gateway Timeout");
    public static final Status HTTP_VERSION_NOT_SUPPORTED = new Status(505, "HTTP Version Not Supported");
    public static final Status LOOP_DETECTED = new Status(506, "Loop Detected");
    public static final Status CROSS_SERVER_BINDING_FORBIDDEN = new Status(507, "Cross-Server Binding Forbidden");

    public Status(int n, String string) {
        this.code = n;
        this.message = string;
        this.extendedStatus = null;
    }

    public Status(Status status, Document document) {
        this.code = status.code;
        this.message = status.message;
        this.extendedStatus = document;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Status && this.code == ((Status)object).getCode();
    }

    public int getCode() {
        return this.code;
    }

    public Document getExtendedStatus() {
        return this.extendedStatus;
    }

    public String getMessage() {
        return this.message;
    }

    public int hashCode() {
        return this.code;
    }

    public boolean sameAs(Object object) {
        if (object == null || !(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        if (status.code != this.code || !status.message.equals(this.message)) {
            return false;
        }
        return status.extendedStatus.equals(this.extendedStatus);
    }

    public String toHTTPString() {
        return "HTTP/1.1 " + this.code + " " + this.message;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.toHTTPString() + ")";
    }
}

