/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTime {
    protected SimpleDateFormat dateFormat;
    protected long dateTime;
    protected static final String RFC_1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    protected static final String RFC_850_PATTERN = "E, dd-MMM-yyyy HH:mm:ss 'GMT'";
    protected static final String ASCTIME_PATTERN = "EEE MMM dd HH:mm:ss yyyy";
    protected static final String ISO_8601_UTC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    protected static final String ISO_8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ssz";
    protected static final String ISO_8601_UTC_MILLIS_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    protected static final String ISO_8601_MILLIS_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSz";

    public DateTime() {
        this(0L);
    }

    public DateTime(long l) {
        this.setDateTime(l);
        this.dateFormat = new SimpleDateFormat();
        this.dateFormat.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US));
    }

    public boolean after(DateTime dateTime) {
        return this.getDateTime() > dateTime.getDateTime();
    }

    public boolean before(DateTime dateTime) {
        return this.getDateTime() < dateTime.getDateTime();
    }

    public boolean equals(DateTime dateTime) {
        return this.getDateTime() == dateTime.getDateTime();
    }

    public long getDateTime() {
        return this.dateTime;
    }

    public int getMilliseconds() {
        return (int)(this.getDateTime() % 1000L);
    }

    public void setDateTime(long l) {
        this.dateTime = l;
    }

    public void setDateTime(String string) {
        String[] stringArray = new String[]{RFC_1123_PATTERN, ISO_8601_UTC_PATTERN, ISO_8601_UTC_MILLIS_PATTERN, ISO_8601_PATTERN, ISO_8601_MILLIS_PATTERN, RFC_850_PATTERN, ASCTIME_PATTERN};
        int n = 0;
        while (n < stringArray.length) {
            if (this.setDateTime(string, stringArray[n])) break;
            ++n;
        }
    }

    protected boolean setDateTime(String string, String string2) {
        boolean bl = true;
        this.dateFormat.applyPattern(string2);
        try {
            this.setDateTime(this.dateFormat.parse(string));
        }
        catch (ParseException parseException) {
            bl = false;
        }
        return bl;
    }

    public void setDateTime(Date date) {
        this.dateTime = date.getTime();
    }

    public Date toDate() {
        return new Date(this.dateTime);
    }

    public String toISO8601() {
        if (this.getMilliseconds() == 0) {
            return this.toString(ISO_8601_UTC_PATTERN);
        }
        return this.toString(ISO_8601_UTC_MILLIS_PATTERN);
    }

    public String toRFC1123() {
        return this.toString(RFC_1123_PATTERN);
    }

    public String toString() {
        return this.toRFC1123();
    }

    protected String toString(String string) {
        this.dateFormat.applyPattern(string);
        return this.dateFormat.format(this.toDate());
    }
}

