/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel.utils;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.webdav.internal.kernel.utils.MergedEnumeration;

public class NestedHashtable {
    protected Hashtable localValues = new Hashtable(5);
    protected NestedHashtable defaults = null;

    public NestedHashtable() {
    }

    public NestedHashtable(NestedHashtable nestedHashtable) {
        this.defaults = nestedHashtable;
    }

    public void collapse() {
        if (this.defaults != null) {
            Enumeration enumeration = this.defaults.keys();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                this.localValues.put(e, this.defaults.get(e));
            }
            this.defaults = null;
        }
    }

    public Object get(Object object) {
        Object v = this.localValues.get(object);
        if (v == null && this.defaults != null) {
            return this.defaults.get(object);
        }
        return v;
    }

    public Enumeration keys() {
        if (this.defaults == null) {
            return this.localValues.keys();
        }
        return new MergedEnumeration(this.localValues.keys(), this.defaults.keys());
    }

    public void put(Object object, Object object2) {
        this.localValues.put(object, object2);
    }

    public Object remove(Object object) {
        return this.localValues.remove(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            stringBuffer.append(e.toString());
            stringBuffer.append(": ");
            stringBuffer.append(this.get(e).toString());
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

